/************************************************************************
 *                                                                      *
 *       (c) Copyright 2003                                             *
 *       All rights reserved                                            *
 *       Programs written by Jianghui Liu (NJIT)                        *
 *                                                                      *
 *       Permission to use, copy, modify, and distribute this software  *
 *       and its documentation for any purpose and without fee is her-  *
 *       eby granted, provided that this copyright notice appears in    *
 *       all copies.   Programmer(s) makes no representations about     *
 *       the suitability of this software for any purpose.  It is pro-  *
 *       vided "as is" without express or implied warranty.             *
 *                                                                      *
 *       08/06/2003                                                     *
 *                                                                      *
 ************************************************************************/
package RNA;
import java.io.*;
import java.util.*;
import java.text.NumberFormat;

public class MultiAligner 
{
    public static void main(String[] args)
    {
        if( args.length == 0 || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help"))
        {
            System.out.println("Usage: ");
            System.out.println("   java MultiAligner -d <Database> -p <Gap Penalty>");
            System.out.println("                     -t <Tolerance> -o <Output>");
            System.out.println("   Default Settings: ");
            System.out.println("   <Tolerance: (0-1)>(default): -t 1");
            System.out.println("   <Gap penalty> (default): -p -2");
            System.out.println("   <Output> (default): -o junk.out");
            System.exit(0);
        }

        String strDB = null;
        double Penalty = -2;
        double Tolerance = 1;
        String Output_file = "junk.out";

        for(int i=0; i<args.length; i++)
        {
            if( args[i].equalsIgnoreCase("-d"))
            {
                strDB = new String(args[i+1]);
                i++;
            } else if( args[i].equalsIgnoreCase("-p")) {
                Penalty = Double.parseDouble(args[i+1]);
                i++;
            } else if( args[i].equalsIgnoreCase("-t")) {
                Tolerance = Double.parseDouble(args[i+1]);
                i++;
            } else if( args[i].equalsIgnoreCase("-o")) {
                Output_file = args[i+1];
                i++;
            } else {
                System.out.println("Illegal parameter " + args[i]);
                System.exit(0);
            }
        }

        if( strDB == null || Penalty >= 0 || Tolerance < 0) 
        {
            System.out.println("Parameter(s) not specified !");
            System.out.println("Try '-h' for help");
            System.exit(0);
        }

        System.out.println("\n\nYour Settings are:");
        System.out.println("Database: " + strDB);
        System.out.println("Tolerance: " + Tolerance);
        System.out.println("Gap Penalty: " + Penalty);
        System.out.println("Output File: " + Output_file + "\n");

        String result[] = MultiAligner.getAlignment(strDB, Penalty, Tolerance);
        System.out.println("\nFinal alignment:");
        System.out.println(result[0]);
        System.out.println("Guide Tree of Multiple Alignment:");
        System.out.println("\n" + result[1]);
       // System.out.println("\nWeight Matrix for PatSearch:");
       // System.out.println("\n" + result[2]);

        try{
            PrintWriter output = new PrintWriter(new FileWriter(Output_file));
            output.println("=== Result of Multiple Alignment ===\n");
            output.println(result[0]);
            output.println("=== Guide Tree of Multiple Alignment ===\n");
            output.println(result[1]);
            //output.println("\n=== Weight Matrix for PatSearch ===\n");
            //output.println(result[2]);
	    output.println("=================================");
	  // output.println(result[3]);	
            output.close();
        } catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }


    //--------------------------------------------------------------------
    // Get multi-structure alignment for the structures in given database
    //--------------------------------------------------------------------
    public static String[] getAlignment(String dataDB, double penalty, double tolerance)
    {
        MultiAlignment seed = HomoUtil.getSeedAlignment(dataDB);
        double[] seedScores = new double[3]; 
	if(seed != null){
	seedScores = seed.getMeasures(penalty);
	}
	else{
	
            System.out.println("\nFATAL ERROR: NO SEED multi-alignment constructucted from the database!\n");
            System.exit(0);
	}	
        NumberFormat nf = NumberFormat.getInstance();
	nf.setMaximumFractionDigits(3);

	ArrayList scores = new ArrayList();
        scores.add(new Double(seedScores[2]));
	String Output_file = "junk.out";
        if( seed == null ) {
            System.out.println("\nFATAL ERROR: NO SEED multi-alignment constructucted from the database!\n");
            System.exit(0);
        }
        ProfileSearcher searcher = new ProfileSearcher(seed);
        System.out.println("\n\nStart Scanning database ...");
        double preScore = Double.NEGATIVE_INFINITY;
        //for(int i=0; i<size; i++) {
        double aScore;
        do{
            aScore = searcher.searchDB(dataDB, penalty);
            scores.add(new Double(aScore));
            //System.out.println("\n" + (i+1) + "th iteration, got maximum score: " + aScore);
            if( aScore <= 0)
                break;

            if( aScore < preScore && (preScore-aScore)/preScore >= tolerance) {
                System.out.println("\nPremature termination by steep decrease of score <" + preScore + 
                                   " -> " + aScore + ">!\n");
                break;
            }
            preScore = aScore;

            String res = searcher.getProfile(penalty);
            //System.out.println("\nThe updated structure multi-aligment is:\n" + res);
        } while (aScore > Double.NEGATIVE_INFINITY);

        String[] names = searcher.getNames();
        //String[] names2 = searcher.getNames(); 
	StringBuffer tree = new StringBuffer();
	
        //#############################new ####################################################

	Object l[] = scores.toArray();
	double l_int[] = new double[100];
	for(int lm =0;lm<names.length;lm++){
		names[lm] = names[lm].replace(':','-');
		//System.out.println("\n"+names[lm]);
	}
	for(int j =0;j<l.length;j++){
		l_int[j] = ((Double)l[j]).doubleValue();
	}	
	StringBuffer tree2 = new StringBuffer();
	tree2.append("(" + names[0] + ":" + Math.abs(l_int[0]/2)  + "," + names[1] + ":" + Math.abs(l_int[0]/2) + ")");
	for(int k=2;k<names.length;k++){
		tree2.append(":" + Math.abs(l_int[k-1]/2) + ",");
		tree2.insert(0, "(");
          	tree2.append(names[k] + ":" + Math.abs(l_int[k-1]/2) + ")");
	}
	tree2.append(";");
	String newick_format;
	newick_format = tree2.toString();


//####################################################################################

	/*tree.append("(" + names[0] + ", " + names[1] + "):" + scores.get(0));
        for(int i=2; i<names.length; i++){
            tree.append(",\n");
            tree.insert(0, "(");
            tree.append(names[i] + "):" + scores.get(i-1) );
        }*/

	
	tree.append("(" + names[0] + ", " + names[1] + "):" + nf.format(l_int[0]));
        for(int i=2; i<names.length; i++){
            tree.append(",\n");
            tree.insert(0, "(");
            tree.append(names[i] + "):" + nf.format(l_int[i-1]));
        }

///##########################################new for the newick format#######################################################
        /*try{
            PrintWriter output2 = new PrintWriter(new FileWriter("./guide.ph"));
            output2.println(newick_format);
            output2.close();
        } catch (IOException e) {
           e.printStackTrace();
           System.exit(0);
        }*/  
//#############################################################################################################################

        String[] ret = new String[4];
        ret[0] =  searcher.getProfile(penalty);
        ret[1] =  tree.toString();
        ret[2] = searcher.getPatWeight();
	ret[3] = tree2.toString();
        return ret;
    }
}
