// --*- C++ -*------x---------------------------------------------------------
// $Id: 
//
// Class:           Physical
// 
// Base class:      -
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Project name:    -
//
// Date:            12/2005
//
// Description:     Concept of a real value with an error 
//                  (a standard deviation)
// 
// Reviewed by:     -
// -----------------x-------------------x-------------------x-----------------

#ifndef __PHYSICAL__
#define __PHYSICAL__

#include <iostream>
#include <math.h>

using namespace std;

class Physical 
{
   
 public:

  Physical() : value(0.0), error(0.0) { }

  Physical(double v, double e) : value(v), error(e) { }

  Physical(const Physical& other) { copy(other); }

  Physical& operator= (const Physical& other) {
    if (this != &other) {
      copy(other);
    }
    return *this;
  }

  bool operator == (const Physical& other) {
    return (value == other.value)&& (error==other.error);
  }

  bool operator != (const Physical& other) {
    return !((value == other.value)&& (error==other.error));
  }

  bool operator < (const Physical& other) {
    return (value < other.value);
  }

  bool operator > (const Physical& other) {
    return (value > other.value);
  }

  bool operator <= (const Physical& other) {
    return (value <= other.value);
  }

  bool operator >= (const Physical& other) {
    return (value >= other.value);
  }

  Physical operator + (const Physical& other) {
    double v = value + other.value;
    double e = sqrt(error*error + other.error*other.error);
    return Physical(v,e);
  }

  Physical operator - (const Physical& other) {
    double v = value - other.value;
    double e = sqrt(error*error + other.error*other.error);
    return Physical(v,e);
  }

  Physical operator * (const Physical& other) {
    double v = value * other.value;
    double e = sqrt(square(other.value*error) 
		    + square(value*other.error));
    return Physical(v,e);
  }

  Physical operator / (const Physical& other) {
    double v = value / other.value;
    double e = sqrt(square(error/other.value) 
		    + square(value*other.error/square(other.value)));
    return Physical(v,e);
  }

  friend ostream& operator << (ostream& os, const Physical& rval);

  double getValue() const { return value; }
  
  double getError() const { return error; }
  
  bool isPrecise() const { return error == 0.0; }
  
  void setValue(double d) { value = d; }
  
  void setError(double d) { error = d; }
  
  void copy(const Physical& other) { 
    value = other.value;
    error = other.error; 
  }
  
  
private:
  
  double square(double d) { return d * d; }
  
  /* ATTRIBUTES */
  
  double value;
  
  double error;
  
};

inline 
ostream& 
operator << (ostream& os, const Physical& rval)
{
  os << rval.getValue() << "+-" << rval.getError();
  return os;
}

#endif
