#ifndef __ALIGN_COLOR_HELP__
#define __ALIGN_COLOR_HELP__

#include <RankedSolution4.h>

/** sort vector of elements (fast!)
    but also return the old rank order as Vec<unsigned int> 
*/
template <class T>
inline
Vec<unsigned int>
documentedSort(Vec<T>& v)
{
  PRECOND(v.size() > 0, exception);
  // RankedSolution4<T,unsigned int> t;
  Vec<RankedSolution4<T, unsigned int> > order(v.size());
  for (unsigned int i = 0; i < order.size(); ++i) {
    order[i] = RankedSolution4<T,unsigned int>(v[i], i);
  }
  sort(order.begin(), order.end());
  Vec<unsigned int> resultOrder(v.size());
  for (unsigned int i = 0; i < v.size(); ++i) {
    resultOrder[i] = order[i].second;
    v[i] = order[i].first;
  }
  return resultOrder;
}

/** sort vector of elements (fast!)
    but also return the old rank order as Vec<unsigned int> 
*/
template <class T>
inline
Vec<unsigned int>
documentedOrder(const Vec<T>& v)
{
  PRECOND(v.size() > 0, exception);
  // RankedSolution4<T,unsigned int> t;
  Vec<RankedSolution4<T, unsigned int> > order(v.size());
  for (unsigned int i = 0; i < order.size(); ++i) {
    order[i] = RankedSolution4<T,unsigned int>(v[i], i);
  }
  sort(order.begin(), order.end());
  Vec<unsigned int> resultOrder(v.size());
  for (unsigned int i = 0; i < v.size(); ++i) {
    resultOrder[i] = order[i].second;
    // v[i] = order[i].first;
  }
  return resultOrder;
}

/** computes variance from sum and sum of squares */
inline
double
varianceFromSum(double sum, double sumSquares, unsigned int n)
{
  if (n < 2) {
    return 0.0;
  }
  double result = (sumSquares/n) - ((sum * sum) / (n * n));
  if (result < 0.0) {
    result = 0.0;
  }
  double correction = static_cast<double>(n) / static_cast<double>(n-1);
  return correction * result;
} 


#endif
