// -*- C++ -*-
// $Id: debug.h,v 1.1.1.1 2004/05/21 18:03:17 bindewae Exp $
// debug.h
// General error-handling and debugging facilities in C++
// 
// This header file provides some macros or inlined functions:
//
//      ASSERT(assertion, exception)
//          checks if assertion is true and throws exeption otherwise.
//          Additionally, a message containing LOCATION is displayed.
//
//      PRECOND(assertion, exception), POSTCOND(assertion, exception) :
//          alias names for ASSERT.
//
//      ERROR(message, exception)
//          prints message and throws exception.
//
//      ERROR_IF(condition, message, exception)
//          throws exception if condition is true.
//
//      NDEBUG
//          if defined, assertions are switched off


#ifndef __DEBUG_H__
#define __DEBUG_H__

extern "C" {
#include <stdlib.h>
}

#include <iostream>
#include <fstream>

#ifndef NDEBUG

#define ASSERT(assertion, exception) {                              \
   if (!(assertion)) {                                              \
      cerr << __FILE__ << ":" << __LINE__ << ":"                 \
	    << __FUNCTION__ << endl                                 \
	    <<  "Assert: assertion violated." << endl       \
	    << "Aborting." << endl << flush;               \
      exit(1);             \
   } }                     \


#define PRECOND(a, b)   ASSERT(a, b)
#define POSTCOND(a, b)  ASSERT(a, b)

#else /* NDEBUG */

#define ASSERT(a, b)
#define PRECOND(a, b) 
#define POSTCOND(a, b) 

#endif /* NDEBUG */

#define ERROR(message, exception) {                                 \
  cerr << message << " Aborting." << endl << flush;                    \
  exit(1); }

#define ERROR_IF(condition, message, exception) {                            \
  if (condition) { ERROR(message, exception); } }

#endif /* __DEBUG_H__ */


