#ifndef __COLOR_FUNCIONS_H__
#define __COLOR_FUNCIONS_H__

#include <string>
#include <Vec.h>
#include <Vector3D.h>
// #include <vectornumerics.h>



/* return rainbow like mapping from value between 0.0 and maxVal */
Vector3D 
rainbow(double x, double minVal, double maxVal);

/* return rainbow like mapping from value between 0.0 and maxVal */
Vector3D 
rainbow2(double x, double minVal, double maxVal);

/* return rainbow like mapping from value between 0.0 and maxVal */
inline
Vector3D 
rainbow(double x) { return rainbow(x, 0.0, 1.0); }

/* return rainbow like mapping from value between 0.0 and maxVal */
inline
Vector3D 
rainbow2(double x) { return rainbow(x, 0.0, 1.0); }

/* return rainbow like mapping from value between 0.0 and 1.0
   use discretization */
Vector3D 
rainbow(double xOrig, double minVal, double maxVal, unsigned int discrete);

Vec<Vector3D> generateRainbowColors(unsigned int n);

bool isRgbColor(const Vector3D& c);

// Vector3D computeColor(const Vec<double>& vOrig, const Vec<Vector3D>& colors);

Vector3D computeRainbowColor(const Vec<double>& vOrig);


#endif
