#ifndef __PROBE_STEM_ENERGY_MODEL__
#define __PROBE_STEM_ENERGY_MODEL__

#include <StemEnergyModel.h>

/** Base class for energy models generating an energy for a stem */
class ProbeStemEnergyModel : public StemEnergyModel {
 private:
  Vec<double> probeData;

 public:

  ProbeStemEnergyModel(const Vec<double>& data) : probeData(data) { ASSERT(data.size() > 0); ASSERT(probeData.size()> 0); }

  virtual ~ProbeStemEnergyModel() { }

  ProbeStemEnergyModel(const ProbeStemEnergyModel& other) { copy(other); }

  ProbeStemEnergyModel& operator = (const ProbeStemEnergyModel& other) {
    if (&other != this) {
      copy(other);
    }
    return *this;
  }
  
  void copy(const ProbeStemEnergyModel& other) {
    probeData = other.probeData;
  }

  /** Computes energy of a stem. Sequence fragments must be stored in stem. */
  virtual double computeEnergy(const Stem& stem) const {
    ASSERT(stem.getLength() > 0);
    if (probeData.size() == 0) {
      return 0.0; 
    }
    double sum = 0.0;
    for (Stem::index_type i = 0; i < stem.getLength(); ++i) {
      ASSERT(stem.getStart() + i < static_cast<int>(probeData.size()));
      ASSERT(stem.getStop() - i < static_cast<int>(probeData.size()));
      ASSERT(stem.getStop() - i >= 0);
      sum += probeData[stem.getStart() + i];
      sum += probeData[stem.getStop() - i];
    }
    double result = sum / (2.0 * stem.getLength());
    return result;
  }

  /** Computes energy given the total sequence */
  virtual double computeEnergy(const Stem& stem, const string& s) const { 
    return computeEnergy(stem);
  }

};

#endif
