#ifndef __STEM_ENERGY_MODEL__
#define __STEM_ENERGY_MODEL__

#include <Stem.h>

/** Base class for energy models generating an energy for a stem */
class StemEnergyModel {

 public:

  virtual ~StemEnergyModel() { }

  /** Computes energy of a stem. Sequence fragments must be stored in stem. */
  virtual double computeEnergy(const Stem& stem) const = 0;

  /** Computes energy given the total sequence */
  virtual double computeEnergy(const Stem& stem, const string& s) const = 0;

};

#endif
