// --*- C++ -*------x---------------------------------------------------------
#ifndef __BIRTHDAY_PROB_ALL_TEST__
#define __BIRTHDAY_PROB_ALL_TEST__

#include <iostream>
#include <BirthdayProbAll.h>
// #include <BirthdayProbPtr.h>
#include <Limits.h>

using namespace std;

class BirthdayProbAllTest {

 public:
  typedef BirthdayProbAll::int_type int_type;
  typedef BirthdayProbAll::index_array index_array;
  
  static void testAll() {
    testComputePSystematic6();
    testComputePSystematic();
  }

  static void testComputePSystematic() {
    // BirthdayProbAll birthdaysPtr;
    // int_type iterMax = 10000;
    for (int_type k = 5; k <= 5; ++k) { // count over outcomes
      index_array dimensions(k+1, k);
      index_array ndims = dimensions; 
      BirthdayProbAll birthdays(k, dimensions);
      cout << "Initialized BirthdayProbAll with array dimensions " << birthdays.getMatrices().getDimensions() << endl; 
      cout << "Counts have to be smaller than " << birthdays.getCountMax() << " from outcomes: " << birthdays.getOutcomeMax() << endl;
      for (int_type n = 1; n < 4; ++n) {
        double pSum = 0.0;
	for (int_type m1 = 0; m1 <= n; ++m1) {
	  for (int_type m2 = 0; m2 <= n; ++m2) {
	    for (int_type m3 = 0; m3 <= n; ++m3) {
	      for (int_type m4 = 0; m4 <= n; ++m4) {
                if ((m1 + 2*m2 + 3*m3 + 4*m4) == n) {
		  ndims[0] = n; 
		  ndims[1] = m1; 
		  ndims[2] = m2; 
		  ndims[3] = m3; 
		  ndims[4] = m4; 

		  cout << "Final result: " << k << " " << n << " " << m1 << " " << m2 << " " << m3 << " " << m4 << " "; 
		  double prob = birthdays.exactProb(ndims); // (k,n,m1,m2,m3,m4);
		  cout << " " << prob << endl; 
		  pSum += prob; 
		}
	      } 
	    }
	  }
	}
	cout << "P-sum for " << k << " " << n << " : " << pSum << endl;
	ASSERT(isSimilar(pSum, 1.0));
      }
    }
  }
  static void testComputePSystematic6() {
    // BirthdayProbAll birthdaysPtr;
    // int_type iterMax = 10000;
    for (int_type k = 6; k <= 6; ++k) { // count over outcomes
      index_array dimensions(k, k);
      index_array ndims = dimensions; 
      BirthdayProbAll birthdays(k, dimensions);
      cout << "Initialized BirthdayProbAll with array dimensions " << birthdays.getMatrices().getDimensions() << endl; 
      cout << "Counts have to be smaller than " << birthdays.getCountMax() << " from outcomes: " << birthdays.getOutcomeMax() << endl;
      for (int_type n = 1; n < 4; ++n) {
        double pSum = 0.0;
	for (int_type m1 = 0; m1 <= n; ++m1) {
	  for (int_type m2 = 0; m2 <= n; ++m2) {
	    for (int_type m3 = 0; m3 <= n; ++m3) {
	      for (int_type m4 = 0; m4 <= n; ++m4) {
		for (int_type m5 = 0; m5 <= n; ++m5) {
		  if ((m1 + 2*m2 + 3*m3 + 4*m4 + 5*m5) == n) {
		    ndims[0] = n; 
		    ndims[1] = m1; 
		    ndims[2] = m2; 
		    ndims[3] = m3; 
		    ndims[4] = m4; 
		    ndims[5] = m5; 
		    
		    cout << "Final result: " << k << " " << n << " " << m1 << " " << m2 << " " << m3 << " " << m4 << " "; 
		    double prob = birthdays.exactProb(ndims); // (k,n,m1,m2,m3,m4);
		    cout << " " << prob << endl; 
		    pSum += prob; 
		  }
		} 
	      }
	    }
	  }
	}
	cout << "P-sum for " << k << " " << n << " : " << pSum << endl;
	ASSERT(isSimilar(pSum, 1.0));
      }
      }
  }

};

#endif
