// --*- C++ -*------x---------------------------------------------------------
#ifndef __LOCORNA_PAR_MAIN__
#define __LOCORNA_PAR_MAIN__

#include <iostream>
#include <HashCorrelationFinder.h>
#include <Stem.h>
#include <LocoRnaMain.h>

using namespace std;

// defines number of alignment blocks to be expected in MAF file:
// #define MAF_RESERVE 1000000

class LocoRnaParMain : public LocoRnaMain {

 private:

  int tasksPerThread;
  int threadCount; // number of threads
  length_type blockSizeMin;

 public:

  LocoRnaParMain(ostream& os, int _argc, char ** _argv, char ** _env) : LocoRnaMain(os, _argc, _argv, _env) { 
    setDefaultValues();
    parseCommandLine();
  }

  static void writeUsageMessage(ostream& os);

  static void writeWelcomeMessage(ostream& os);

  int run();

  virtual void parseCommandLine();
  
  virtual void setDefaultValues();
 
};

#endif
