// --*- C++ -*------x---------------------------------------------------------
#ifndef __MAF_ALIGNMENT_TEST__
#define __MAF_ALIGNMENT_TEST__

#include<iostream>
#include<fstream>
#include <MAFAlignment.h>
#include <NucleotideTools.h>
#include <debug.h>

using namespace std;

class MAFAlignmentTest {

 public:
  typedef MAFAlignment::length_type length_type;

 public:

  static void testExtractAssemblySequence();

  /**
     Extracts complete hg18 sequence from chrM
  */
  static void testExtractCompleteAssemblySequence();


  static void testAlmostComplementary() {
    string s1 = "AA-CC-GG-TT-";
    string s1c = NucleotideTools::dnaComplement(s1);
    cout << s1 << "\t" << s1c << endl;
    double allowedGuFrac = 0.0;
    double allowedGapFrac = 0.3;
    ASSERT(NucleotideTools::isAlmostComplementary(s1, s1c, allowedGuFrac, allowedGapFrac));
  }

  /**
   * Extracts complete chimpanzee (panTro2) sequence 
   * from hg18/chrM MAF alignments
  */
  static void testExtractCompleteChimpAssemblySequence();

  static void testFilterMAF();

  static void testFilterMAF2();

  static void testRead();

  static void testAppendSmall();

  static void testReadSmall();

  static void testReadFASTA();

  static void testReverseComplement();

  static void testShuffleHorizontal();

  static void testShuffleRows();

  static void testShuffleVertical();
  
  static void testAppend();
  
  static int main(int argc, char **argv) {
    MAFAlignmentTest tester;
    tester.testAlmostComplementary();
    exit(1);

    tester.testAppendSmall();
    tester.testReadSmall();
    tester.testExtractCompleteChimpAssemblySequence();
    tester.testExtractCompleteAssemblySequence();
    tester.testShuffleHorizontal();
    tester.testShuffleRows();
    tester.testShuffleVertical();
    tester.testExtractAssemblySequence();
    tester.testFilterMAF();
    tester.testFilterMAF2();
    tester.testReverseComplement();
    tester.testRead();
    tester.testReadFASTA();
    tester.testAppend();

    return 0;
  }


};


#endif
