// --*- C++ -*------x---------------------------------------------------------
#ifndef _SEARCH_TABLES_
#define _SEARCH_TABLES_

#include <MAFAlignment.h>

class SearchTables {

 public:

  typedef MAFAlignment::length_type length_type;

  virtual ~SearchTables() { }

  virtual void run() = 0;

  /** Sets parameter that determines what fraction of possible hash tables are actually generated */
  virtual void setAssemblyPairFraction(double value) = 0;

  virtual void setMAF(MAFAlignment * maf) = 0;

  virtual void setSearchRangeMin(length_type index) = 0;

  virtual void setSearchRangeMax(length_type index) = 0;

  virtual void setVerbose(int verbose) = 0;

  virtual bool validate() const = 0; 



};

#endif


