// --*- C++ -*------x---------------------------------------------------------
#ifndef __SINGLE_LINKAGE_2D_PROGRESSIVE_FILTER_TEST__
#define __SINGLE_LINKAGE_2D_PROGRESSIVE_FILTER_TEST__

#include <SingleLinkage2DProgressiveFilter.h>

class SingleLinkage2DProgressiveFilterTest {

 public:
  typedef SingleLinkage2DProgressiveFilter::result_type result_type;
  typedef SingleLinkage2DProgressiveFilter::length_type length_type;
  typedef SingleLinkage2DProgressiveFilter::size_type size_type;

  static void testAll() {
    testInactive();
    testIsolated();
    testCombined();
    testMixed();
  }

  static void testCombined() {
    string methodName = "testCombined";
    cout << "Starting method " << methodName << endl;
    length_type cutoff = 60;
    length_type pc = 0;
    SingleLinkage2DProgressiveFilter filter(cutoff, pc);

    size_type numRounds = 10;
    result_type finalResult; 
    for (size_type i = 0; i <= numRounds; ++i) {
      cout << "test round " << i << " filter status: " << endl;
      filter.write(cout);
      cout << endl;
      ASSERT(filter.getElementCount() == i);
      result_type result; 
      length_type y = 2*i + 1;
      if (i < numRounds) {
	length_type x = (cutoff-1)*i;
	result = filter.push(x , y);
	cout << "Result of adding " << x << " " << y << " : " << result.size() << " clusters." << endl;
	cout << "Number of elements in filter: " << filter.size() << endl;
      } else {
	result = filter.flushAll();
	cout << "Result of flush : " << result.size() << " clusters." << endl;
      }
      for (result_type::size_type j = 0; j < result.size(); ++j) {
	finalResult.push_back(result[j]);
      }
    }
    filter.writeClusters(finalResult);
    ASSERT(static_cast<length_type>(finalResult.size()) == 1); // only one cluster
    cout << "Finished method " << methodName << endl;
  }

  static void testIsolated() {
    string methodName  = "testIsolated";
    cout << "Starting method " << methodName << endl;
    length_type cutoff = 60;
    length_type pc = 0;
    SingleLinkage2DProgressiveFilter filter(cutoff, pc);
    length_type y = 10;
    length_type numRounds = 10;
    result_type finalResult; 
    filter.setCheckDiagonalMode(false); // switch off checking for diagonals (stems) 
    for (length_type i = 0; i <= numRounds; ++i) {
      cout << "test round " << i << " filter status: " << endl;
      filter.write(cout);
      result_type result; 
      if (i < numRounds) {
	length_type x = (cutoff+1)*i;
	result = filter.push(x , y);
	cout << "Result of adding " << x << " " << y << " : " << result.size() << " clusters." << endl;
      } else {
	result = filter.flushAll();
	cout << "Result of flush : " << result.size() << " clusters." << endl;
      }
      for (result_type::size_type j = 0; j < result.size(); ++j) {
	ASSERT(result[j].size() == 1);
	ASSERT((result[j][0]).second == y);
	finalResult.push_back(result[j]);
      }
    }
    filter.writeClusters(finalResult);
    ASSERT(static_cast<length_type>(finalResult.size()) == numRounds);
    cout << "Finished method " << methodName << endl;
  }

  static void testMixed() {
    string methodName = "testCombined";
    cout << "Starting method " << methodName << endl;
    length_type cutoff = 60;
    length_type pc = 0;
    SingleLinkage2DProgressiveFilter filter(cutoff, pc);
    filter.setCheckDiagonalMode(false);
    length_type numRounds = 10;
    result_type finalResult; 
    for (length_type i = 0; i <= numRounds; ++i) {
      cout << "test round " << i << " filter status: " << endl;
      filter.write(cout);
      cout << endl;
      // ASSERT(filter.getElementCount() == i);
      result_type result; 
      length_type y = 2*i + 1;
      if (i < numRounds) {
	// length_type x = (cutoff-1)*i;
	i % 2 == 1 ? pc += cutoff -1 : pc += cutoff + 1;
	result = filter.push(pc , y);
	cout << "Result of adding " << pc << " " << y << " : " << result.size() << " clusters." << endl;
	cout << "Number of elements in filter: " << filter.size() << endl;
      } else {
	result = filter.flushAll();
	cout << "Result of flush : " << result.size() << " clusters." << endl;
      }
      for (result_type::size_type j = 0; j < result.size(); ++j) {
	finalResult.push_back(result[j]);
      }
    }
    filter.writeClusters(finalResult);
    ASSERT(static_cast<length_type>(finalResult.size()) == (numRounds/2)); 
    cout << "Finished method " << methodName << endl;
  }

  static void testInactive() {
    string methodName = "testInactive";
    cout << "Starting method " << methodName << endl;
    length_type cutoff = 60;
    length_type pc = 0;
    SingleLinkage2DProgressiveFilter filter(cutoff, pc);
    filter.setActive(false);
    length_type numRounds = 10;
    result_type finalResult; 
    for (length_type i = 0; i <= numRounds; ++i) {
      cout << "test round " << i << " filter status: " << endl;
      filter.write(cout);
      cout << endl;
      // ASSERT(filter.getElementCount() == i);
      result_type result; 
      length_type y = 2*i + 1;
      if (i < numRounds) {
	// length_type x = (cutoff-1)*i;
	i % 2 == 1 ? pc += cutoff -1 : pc += cutoff + 1;
	result = filter.push(pc , y);
	cout << "Result of adding " << pc << " " << y << " : " << result.size() << " " << result[0].size() << " " 
	     << result[0][0].first << " " << result[0][0].second << endl;
	ASSERT(result.size() == 1);
	ASSERT(result[0].size() == 1);
        ASSERT(result[0][0].first == pc);
	ASSERT(result[0][0].second == y);
	cout << "Number of elements in filter: " << filter.size() << endl;
      } else {
	result = filter.flushAll();
	cout << "Result of flush : " << result.size() << " clusters." << endl;
      }
      for (result_type::size_type j = 0; j < result.size(); ++j) {
	finalResult.push_back(result[j]);
      }
    }
    filter.writeClusters(finalResult);
    ASSERT(static_cast<length_type>(finalResult.size()) == (numRounds)); 
    cout << "Finished method " << methodName << endl;
  }


};

#endif
