#ifndef __NUCLEOTIDE_TOOLS__
#define __NUCLEOTIDE_TOOLS__

#include <ctype.h>

class NucleotideTools {

 public:
  
  typedef string::size_type size_type;

  /** returns true if c equals a purine (c equals 'A' or 'G') */
  static bool isPurine(char c) {
    c = toupper(c);
    return (c == 'A') || (c == 'G');
  }

  /** returns true if c equals a purine (c equals 'A' or 'G') */
  static bool isPyrimidine(char c) {
    c = toupper(c);
    return (c == 'C') || (c == 'U') || (c == 'T');
  }

  /** returns number of purines in string */
  static size_type countPurines(const string& s) {
    size_type count = 0;
    for (string::size_type i = 0; i < s.size(); ++i) {
      if (isPurine(s[i])) {
	++count;
      }
    }
    return count;
  }

  /** returns number of purines in string */
  static size_type countPyrimidines(const string& s) {
    size_type count = 0;
    for (string::size_type i = 0; i < s.size(); ++i) {
      if (isPyrimidine(s[i])) {
	++count;
      }
    }
    return count;
  }

};

#endif
