// --*- C++ -*------x---------------------------------------------------------
// $Id: SequenceMutator.cc,v 1.1.1.1 2006/07/03 14:43:20 bindewae Exp $
//
// Class:           SequenceMutator
// 
// Base class:      -
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Project name:    -
//
// Date:            $Date: 2006/07/03 14:43:20 $
//
// Description:     - 
// -----------------x-------------------x-------------------x-----------------

#include <SequenceMutator.h>

// ---------------------------------------------------------------------------
//                                   SequenceMutator
// -----------------x-------------------x-------------------x-----------------

/* CONSTRUCTORS */

/* default constructor */
SequenceMutator::SequenceMutator() 
{
  initDefault();
}

/* recommended constructor */
SequenceMutator::SequenceMutator(const string& s) :
  sequenceOrig(s)
{
  initDefault();
  sequenceCurr = sequenceOrig;
}

/* copy constructor */
SequenceMutator::SequenceMutator(const SequenceMutator& other)
{
  copy(other);
}

/* destructor */
SequenceMutator::~SequenceMutator() { }


/* OPERATORS */

/** Assigment operator. */
SequenceMutator& 
SequenceMutator::operator = (const SequenceMutator& orig)
{
  if ((&orig) != this) {
    copy(orig);
  }
  return *this;
}

ostream&
operator << (ostream& os, const SequenceMutator& rval)
{
  os << rval.sequenceOrig << " " << rval.sequenceCurr << " " 
     << rval.shift << " " << rval.shiftMax << " " << rval.insLen << " " 
     << rval.insMax << " "
     << rval.insPos << " " << rval.delLen << " " << rval.delMax << " " 
     << rval.delPos;
  return os;
}


/* PREDICATES */

/** Is current state valid?

    Use this predicate to check if the network connection is
    established and working. 

    @author Eckart Bindewald 
    @return true <=> current state is valid 
    @bugs   
    @see     */
bool
SequenceMutator::isValid() const
{
  return (sequenceOrig.size() > 0) && hasNext();
}

bool
SequenceMutator::hasNext() const
{
  return (shift < shiftMax);
}

/* MODIFIERS */

/* copy method */
void 
SequenceMutator::copy(const SequenceMutator& other)
{


}

void 
SequenceMutator::reset() {
  shift = -abs(shiftMax); // shift: -shiftMax .. shiftMax
  insLen = 0;
  insPos = 1;
  delLen = 0;
  delPos = 0;
}


void 
SequenceMutator::initDefault() {
  shiftMax = 1;
  insMax = 1; // 1;
  delMax = 1; // 1;
  reset();
}

void
SequenceMutator::incPerm() 
{
  // cout << "State before incPerm: " << *this << endl;
  int nn = sequenceOrig.size();
  bool isOk = false;
  while ((!isOk) && (shift <= shiftMax)) {
    isOk = true;
    if (insLen <= insMax) {
      ++insLen;
      if (!insertionPossible()) {
	isOk = false;
      }
    }
    else if (insPos < nn) {
      insLen = 1;
      ++insPos;
      if (!insertionPossible()) {
	isOk = false;
      }
    }
    else if (delLen <= delMax) {
      ++delLen;
      if (!deletionPossible()) {
	isOk = false;
      }
    }
    else if (delPos < nn) {
      delLen = 1;
      ++delPos;
      if (!deletionPossible()) {
	isOk = false;
      }
    }
    else if (shift <= shiftMax) {
      ++shift;
      insLen = 0;
      insPos = 1;
      delLen = 0;
      delPos = 1;
    }
  }
  // cout << "State after incPerm: " << *this << endl;
}

bool
SequenceMutator::deletionPossible() 
{
  int nn = sequenceOrig.size();
  if ((delLen > delMax) || (delPos >= nn)) {
    return false;
  }
  // check of all characters to be deleted are GAP_CHARS
  for (int i = 0; i < delLen; ++i) {
    int p = delPos + i;
    if ((p >= nn)
	|| (sequenceOrig[p] != GAP_CHAR)) {
      return false;
    }
  }
  // now check if there is a least one non-gap char in front
  bool found = false;
  for (int i = 0; i < delPos; ++i) {
    if (sequenceOrig[i] != GAP_CHAR) {
      found = true;
      break;
    }
  }
  if (!found) {
    return false; // there was no non-gap char at before deletion point
  }
  // now check if there is a least one non-gap char at end after deletion
  for (int i = delPos + delLen; i < nn; ++i) {
    if (sequenceOrig[i] != GAP_CHAR) {
      return true;
    }
  }
  return false; // the deletion was too late
}

bool
SequenceMutator::insertionPossible() 
{
  int nn = sequenceOrig.size();
  if ((insPos < 1) ||  (insLen > insMax) || (insPos >= nn)) {
    return false;
  }
  if (nn - insPos - insLen < 1) {
    return false;
  }
  bool found = false;
  for (int i = 0; i < insPos; ++i) {
    if (sequenceOrig[i] != GAP_CHAR) {
      found = true;
      break;
    }
  }
  if (!found) {
    return false; // there was no non-gap char at before deletion point
  }
  // now check if there is a least one non-gap char at end after deletion
  for (int i = insPos; i < nn; ++i) {
    if (sequenceOrig[i] != GAP_CHAR) {
      return true;
    }
  }
  return false;
}
void
SequenceMutator::updateSequence() 
{


  sequenceCurr = sequenceOrig;
  int nn = sequenceOrig.size();
  if (insertionPossible()) {
    ASSERT(nn - insPos - insLen > 0);
    // cout << "Inserting!" << insPos << " " << insLen << endl;
    sequenceCurr = sequenceCurr.substr(0, insPos)
      + string(insLen, GAP_CHAR) + sequenceCurr.substr(insPos, 
		       nn - insPos - insLen);
  }
  else if (deletionPossible()) {
    // cout << "Deleting!" << delPos << " " << delLen << endl;
    sequenceCurr = sequenceCurr.substr(0, delPos)
      + sequenceCurr.substr(delPos + delLen)
      + string(delLen, GAP_CHAR);
  }
  if (shift <= shiftMax) {
    // cout << "Shifting " << shift << endl;
    if (shift < 0) {
      sequenceCurr = sequenceCurr.substr(abs(shift))
	+ string(abs(shift), GAP_CHAR);
    }
    else if (shift > 0) {
      sequenceCurr = string(shift, GAP_CHAR)
	+ sequenceCurr.substr(0, sequenceCurr.size() - shift);
    }
  }
  // cout << sequenceOrig << endl << sequenceCurr << endl;
  // cout << "State after Update: " << *this << endl;
  POSTCOND(sequenceCurr.size() == sequenceOrig.size());
}

void
SequenceMutator::nextSequence() 
{
  PRECOND(hasNext());
  // string result = currSequence; // current sequence is "next" sequence
  incPerm();
  updateSequence();
  // return result;
}

