#ifndef __MULTI_VAL_ARRAY_TOOLS__
#define __MULTI_VAL_ARRAY_TOOLS__

#include <MultiValArray.h>

class MultiValArrayTools {

 public:
  
  typedef MultiValArray::index_array index_array;
  typedef MultiValArray::size_type size_type;

  static void write2D(ostream& os, const MultiValArray& array) {
    index_array dimensions = array.getDimensions();
    ASSERT(dimensions.size() == 2);
    index_array input(2);
    for (size_type i = 0; i < dimensions[0]; ++i) {
      for (size_type j = 0; j < dimensions[1]; ++j) {
        input[0] = i;
        input[1] = j;
	os << array.get(input) << " ";
      }
      os << endl;
    }
    os << endl;
  }

  static void write3D(ostream& os, const MultiValArray& array) {
    index_array dimensions = array.getDimensions();
    ASSERT(dimensions.size() == 3);
    index_array input(3);
    for (size_type i = 0; i < dimensions[0]; ++i) {
      for (size_type j = 0; j < dimensions[1]; ++j) {
	for (size_type k = 0; k < dimensions[2]; ++k) {
	  input[0] = i;
	  input[1] = j;
	  input[2] = k;
	  os << array.get(input) << " ";
	}
        os << endl;
      }
      os << endl;
    }
    os << endl;
  }
  
};

#endif
