#ifndef DEBUG_H
#define DEBUG_H 

extern "C" {
#include <stdlib.h>
}

#include <iostream>
#include <assert.h>

using namespace std;

#define DEBUG_STREAM cerr

#define QUIT  exit(1)

inline
void
DEBUG_MSG(const string& s) {
#ifndef NDEBUG
  cerr << s << endl;
#endif  
}

#ifndef NDEBUG
#define ASSERT(condition) {                                                           \
  if (!(condition)) {                                                                   \
    DEBUG_STREAM << "File: " << __FILE__ << " Line: " << __LINE__ << " Function: "    \
	 << __FUNCTION__ << endl;                                                     \
    DEBUG_STREAM << "An assertion was not fullfilled. Aborting." << endl;    \
    QUIT ;                                                                            \
  } }                                                                                  
#else
#define ASSERT(condition) { }                                                           
#endif

#ifndef NDEBUG
#define PRECOND(condition) {                                                           \
  if (!(condition)) {                                                                   \
    DEBUG_STREAM << "File: " << __FILE__ << " Line: " << __LINE__ << " Function: "    \
	 << __FUNCTION__ << endl;                                                     \
    DEBUG_STREAM << "A pre-condition was not fullfilled. Aborting." << endl;    \
    QUIT ;                                                                            \
  } }                                                                                  
#else
#define PRECOND(condition) { }                                                           
#endif

#ifndef NDEBUG
#define POSTCOND(condition) {                                                           \
  if (!(condition)) {                                                                   \
    DEBUG_STREAM << "File: " << __FILE__ << " Line: " << __LINE__ << " Function: "    \
	 << __FUNCTION__ << endl;                                                     \
    DEBUG_STREAM << "An post-condition was not fullfilled. Aborting." << endl;    \
    QUIT ;                                                                            \
  } }                                                                                  
#else
#define POSTCOND(condition) { }                                                           
#endif

#ifndef NDEBUG
#define INVARIANT(condition) {                                                           \
  if (!(condition)) {                                                                   \
    DEBUG_STREAM << "File: " << __FILE__ << " Line: " << __LINE__ << " Function: "    \
	 << __FUNCTION__ << endl;                                                     \
    DEBUG_STREAM << "An invariant was not fullfilled. Aborting." << endl;    \
    QUIT ;                                                                            \
  } }                                                                                  
#else
#define INVARIANT(condition) { }                                                           
#endif

inline
void
ERROR(const string& message) {
  cerr << message << endl;
  exit(1);
}

inline
void
ERROR_IF(bool condition, 
	 const string& message) {
  if (condition) {
    DEBUG_STREAM << message << endl;
    QUIT ;
  }
}

#endif
