nucleotides.reverseComplement <- function(s, dna=FALSE, strict=TRUE, convertCtoU=FALSE) {
	len <- nchar(s)
	result <- ""
	for (i in 1:len) {
		result <- paste(nucleotide.complement(substr(s, i, i), dna=dna, strict=strict), result, sep="")
	}
	result
}

test.nucleotides.reverseComplement <- function() {
	cat("RNA Reverse complement of AAUUCC:", nucleotides.reverseComplement("AAUUCC", dna=FALSE), "\n")
	checkEquals(nucleotides.reverseComplement("AAUUCC"), "GGAAUU")
	cat("DNA Reverse complement of AATTCC:", nucleotides.reverseComplement("AATTCC", dna=TRUE), "\n")
	checkEquals(nucleotides.reverseComplement("AATTCC", dna=TRUE), "GGAATT")
	checkEquals(nucleotides.reverseComplement("A-ATTCC", dna=TRUE, strict=FALSE), "GGAAT-T")
}
