/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.geometry.spline;

import no.geosoft.cc.geometry.spline.Spline;

class CubicSpline
extends Spline {
    CubicSpline(double[] dArray, int n) {
        this.initialize(dArray, n);
    }

    protected void initialize(double[] dArray, int n) {
        this.nParts_ = n;
        this.controlPoints_ = new double[dArray.length + 12];
        System.arraycopy(dArray, 0, this.controlPoints_, 6, dArray.length);
        this.controlPoints_[0] = this.controlPoints_[6];
        this.controlPoints_[1] = this.controlPoints_[7];
        this.controlPoints_[2] = this.controlPoints_[8];
        this.controlPoints_[3] = this.controlPoints_[6];
        this.controlPoints_[4] = this.controlPoints_[7];
        this.controlPoints_[5] = this.controlPoints_[8];
        this.controlPoints_[this.controlPoints_.length - 3] = this.controlPoints_[this.controlPoints_.length - 9];
        this.controlPoints_[this.controlPoints_.length - 2] = this.controlPoints_[this.controlPoints_.length - 8];
        this.controlPoints_[this.controlPoints_.length - 1] = this.controlPoints_[this.controlPoints_.length - 7];
        this.controlPoints_[this.controlPoints_.length - 6] = this.controlPoints_[this.controlPoints_.length - 9];
        this.controlPoints_[this.controlPoints_.length - 5] = this.controlPoints_[this.controlPoints_.length - 8];
        this.controlPoints_[this.controlPoints_.length - 4] = this.controlPoints_[this.controlPoints_.length - 7];
    }

    double[] generate() {
        int n = this.controlPoints_.length / 3;
        int n2 = (n - 3) * this.nParts_ + 1;
        double[] dArray = new double[n2 * 3];
        this.p(2, 0.0, this.controlPoints_, dArray, 0);
        int n3 = 3;
        int n4 = 2;
        while (n4 < n - 1) {
            int n5 = 1;
            while (n5 <= this.nParts_) {
                this.p(n4, (double)n5 / (double)this.nParts_, this.controlPoints_, dArray, n3);
                n3 += 3;
                ++n5;
            }
            ++n4;
        }
        return dArray;
    }

    private void p(int n, double d, double[] dArray, double[] dArray2, int n2) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = (n - 2) * 3;
        int n4 = -2;
        while (n4 <= 1) {
            double d5 = this.blend(n4, d);
            d2 += d5 * dArray[n3++];
            d3 += d5 * dArray[n3++];
            d4 += d5 * dArray[n3++];
            ++n4;
        }
        dArray2[n2 + 0] = d2;
        dArray2[n2 + 1] = d3;
        dArray2[n2 + 2] = d4;
    }

    protected double blend(int n, double d) {
        if (n == -2) {
            return (((-d + 3.0) * d - 3.0) * d + 1.0) / 6.0;
        }
        if (n == -1) {
            return ((3.0 * d - 6.0) * d * d + 4.0) / 6.0;
        }
        if (n == 0) {
            return (((-3.0 * d + 3.0) * d + 3.0) * d + 1.0) / 6.0;
        }
        return d * d * d / 6.0;
    }
}

