/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestSuite;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestRunner;
import org.testng.internal.InvokedMethod;
import org.testng.internal.JUnitUtils;
import org.testng.internal.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitTestRunner
implements TestListener {
    public static final String SUITE_METHODNAME = "suite";
    private TestRunner m_parentRunner;
    private Map<Test, TestRunInfo> m_tests = new WeakHashMap<Test, TestRunInfo>();
    private List<ITestNGMethod> m_methods = new ArrayList<ITestNGMethod>();

    public JUnitTestRunner(TestRunner tr) {
        this.m_parentRunner = tr;
    }

    public List<ITestNGMethod> getTestMethods() {
        return this.m_methods;
    }

    public void startTest(Test test) {
        this.m_tests.put(test, new TestRunInfo(Calendar.getInstance().getTimeInMillis()));
    }

    public void addError(Test test, Throwable t) {
        this.recordFailure(test, t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.recordFailure(test, (Throwable)t);
    }

    private void recordFailure(Test test, Throwable t) {
        TestRunInfo tri = this.m_tests.get(test);
        if (null != tri) {
            tri.setThrowable(t);
        }
    }

    public void endTest(Test test) {
        TestRunInfo tri = this.m_tests.get(test);
        if (null == tri) {
            return;
        }
        TestResult tr = this.recordResults(test, tri);
        JUnitTestRunner.runTestListeners(tr, this.m_parentRunner.getTestListeners());
    }

    private TestResult recordResults(Test test, TestRunInfo tri) {
        JUnitUtils.JUnitTestClass tc = new JUnitUtils.JUnitTestClass(test);
        JUnitUtils.JUnitTestMethod tm = new JUnitUtils.JUnitTestMethod(test, tc);
        TestResult tr = new TestResult(tc, test, tm, tri.m_failure, tri.m_start, Calendar.getInstance().getTimeInMillis());
        if (tri.isFailure()) {
            tr.setStatus(2);
            this.m_parentRunner.addFailedTest(tm, tr);
        } else {
            this.m_parentRunner.addPassedTest(tm, tr);
        }
        this.m_parentRunner.addInvokedMethod(new InvokedMethod(test, tm, new Object[0], true, false, tri.m_start));
        this.m_methods.add(tm);
        return tr;
    }

    private static void runTestListeners(ITestResult tr, List<ITestListener> listeners) {
        block7: for (ITestListener itl : listeners) {
            switch (tr.getStatus()) {
                case 3: {
                    itl.onTestSkipped(tr);
                    continue block7;
                }
                case 4: {
                    itl.onTestFailedButWithinSuccessPercentage(tr);
                    continue block7;
                }
                case 2: {
                    itl.onTestFailure(tr);
                    continue block7;
                }
                case 1: {
                    itl.onTestSuccess(tr);
                    continue block7;
                }
                case 16: {
                    itl.onTestStart(tr);
                    continue block7;
                }
            }
            assert (false) : "UNKNOWN STATUS:" + tr;
        }
    }

    protected Test getTest(Class testClass) {
        Method suiteMethod = null;
        try {
            suiteMethod = testClass.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception e) {
            return new TestSuite(testClass);
        }
        if (!Modifier.isStatic(suiteMethod.getModifiers())) {
            this.runFailed("Suite() method must be static");
            return null;
        }
        Test test = null;
        try {
            test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
            if (test == null) {
                return test;
            }
        }
        catch (InvocationTargetException e) {
            this.runFailed("Failed to invoke suite():" + e.getTargetException().toString());
            return null;
        }
        catch (IllegalAccessException e) {
            this.runFailed("Failed to invoke suite():" + e.toString());
            return null;
        }
        return test;
    }

    public junit.framework.TestResult start(Class testCase) throws Exception {
        try {
            Test suite = this.getTest(testCase);
            return this.doRun(suite);
        }
        catch (Exception e) {
            throw new Exception("Could not create and run test suite: " + e);
        }
    }

    protected void runFailed(String message) {
        System.err.println(message);
    }

    protected junit.framework.TestResult createTestResult() {
        return new junit.framework.TestResult();
    }

    protected junit.framework.TestResult doRun(Test suite) {
        junit.framework.TestResult result = this.createTestResult();
        result.addListener((TestListener)this);
        suite.run(result);
        return result;
    }

    private static class TestRunInfo {
        private final long m_start;
        private Throwable m_failure;

        public TestRunInfo(long start) {
            this.m_start = start;
        }

        public boolean isFailure() {
            return null != this.m_failure;
        }

        public void setThrowable(Throwable t) {
            this.m_failure = t;
        }
    }
}

