/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.Command;
import commandtools.Interpreter;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;

public abstract class AbstractInterpreter
implements Interpreter {
    protected static Logger log;
    protected static Properties variables;
    private Vector<Command> knownCommands = new Vector();

    public AbstractInterpreter(Logger log) {
        AbstractInterpreter.log = log;
    }

    @Override
    public void addKnownCommand(Command command) {
        this.knownCommands.add(command);
    }

    public void clear() {
        this.knownCommands.clear();
    }

    public int countKnownCommands() {
        return this.knownCommands.size();
    }

    public String getKnownCommandNames() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.knownCommands.size(); ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this.knownCommands.get(i).getName());
        }
        return buf.toString();
    }

    protected Command findCommand(String commandName) {
        for (Command currCommand : this.knownCommands) {
            if (!currCommand.getName().equals(commandName)) continue;
            return currCommand;
        }
        return null;
    }

    @Override
    public String autoComplete(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        String completed = null;
        int len = s.length();
        Iterator<Command> i = this.knownCommands.iterator();
        while (i.hasNext()) {
            String command = i.next().getName();
            if (command.length() < len || !command.substring(0, len).equals(s)) continue;
            if (completed == null) {
                completed = command;
                continue;
            }
            return s;
        }
        if (completed == null) {
            return s;
        }
        return completed;
    }

    public Properties getVariables() {
        return variables;
    }

    @Override
    public String getVariable(String name) {
        return variables.getProperty(name);
    }

    @Override
    public void setVariable(String name, String value) {
        variables.setProperty(name, value);
    }

    @Override
    public String getCommandNames() {
        String result = "";
        Iterator<Command> iter = this.knownCommands.iterator();
        while (iter.hasNext()) {
            result = result + " " + iter.next().getName();
        }
        return result;
    }

    static {
        variables = new Properties();
    }
}

