/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandApplication;
import commandtools.CommandExecutionException;
import commandtools.DefinedCommand;
import commandtools.PackageConstants;
import commandtools.StringParameter;

public class DefineCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "define";
    private String definedName;
    private String fileName;
    private CommandApplication application;

    public DefineCommand(CommandApplication application) {
        super(COMMAND_NAME);
        this.application = application;
    }

    @Override
    public Object cloneDeep() {
        DefineCommand command = new DefineCommand(this.application);
        command.definedName = this.definedName;
        command.fileName = this.fileName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    public String helpOutput() {
        return "Reads and executes script file. Correct usage: source filename";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"define\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " COMMANDNAME " + " FILENAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Defines a comand by a command name and a script file name." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.application != null);
        this.prepareReadout();
        DefinedCommand newCommand = new DefinedCommand(this.definedName, this.fileName, "", this.application);
        this.application.getInterpreter().addKnownCommand(newCommand);
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 2) {
            throw new CommandExecutionException(this.helpOutput());
        }
        assert (this.getParameter(0) instanceof StringParameter);
        assert (this.getParameter(1) instanceof StringParameter);
        StringParameter stringParameter0 = (StringParameter)this.getParameter(0);
        this.definedName = stringParameter0.getValue();
        StringParameter stringParameter1 = (StringParameter)this.getParameter(1);
        this.fileName = stringParameter1.getValue();
    }
}

