/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.PackageConstants;
import commandtools.StringParameter;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;

public class EnvCommand
extends AbstractCommand
implements Command {
    public static final String COMMAND_NAME = "env";
    private Properties properties;
    private PrintStream ps;

    public EnvCommand(Properties properties, PrintStream ps) {
        super(COMMAND_NAME);
        this.properties = properties;
        this.ps = ps;
    }

    @Override
    public Object cloneDeep() {
        EnvCommand result = new EnvCommand(this.properties, this.ps);
        for (int i = 0; i < this.getParameterCount(); ++i) {
            result.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return result;
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        Enumeration<?> names = this.properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.ps.println(name + "=" + this.properties.getProperty(name));
        }
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("env ");
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (!(this.getParameter(i) instanceof StringParameter)) continue;
            StringParameter sp = (StringParameter)this.getParameter(i);
            result.append("" + sp.getValue() + " ");
        }
        return result.toString();
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"env\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Env command gives a list of the set variables." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    private String helpOutput() {
        return "Correct usage: env";
    }
}

