/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandApplication;
import commandtools.CommandException;
import commandtools.CommandExecutionException;
import commandtools.PackageConstants;
import commandtools.StringParameter;
import java.io.BufferedReader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.util.Properties;

public class ForeachCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "foreach";
    public static final String BRACKET_OPEN = "(";
    public static final String BRACKET_CLOSE = ")";
    private Properties properties;
    private String varName;
    private String[] varValues;
    private String[] bodyLines;
    private CommandApplication application;

    public ForeachCommand(Properties props, CommandApplication app) {
        super(COMMAND_NAME);
        assert (props != null);
        assert (app != null);
        this.properties = props;
        this.application = app;
        assert (this.properties != null);
        assert (this.application != null);
    }

    @Override
    public Object cloneDeep() {
        ForeachCommand command = new ForeachCommand(this.properties, this.application);
        command.varName = this.varName;
        command.varValues = this.varValues;
        command.bodyLines = this.bodyLines;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    public String helpOutput() {
        return "Performs for loop. Example syntax: foreach varname ( 1 5 10 15 ) echo ${varname} end" + PackageConstants.NEWLINE;
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"foreach\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " VARIABLE ( VAL VAL VAL ) COMMAND end" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Foreach command allows loops." + PackageConstants.NEWLINE + "Example syntax: foreach varname ( 1 5 10 15 ) echo ${varname} end" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    private static BufferedReader generateReader(String[] lines) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            buf.append(lines[i]);
            buf.append(PackageConstants.NEWLINE);
        }
        String resultString = buf.toString();
        return new BufferedReader(new StringReader(resultString));
    }

    private static StringBufferInputStream generateInputStream(String[] lines) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            buf.append(lines[i]);
            buf.append(PackageConstants.NEWLINE);
        }
        String resultString = buf.toString();
        return new StringBufferInputStream(resultString);
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.application != null);
        this.prepareReadout();
        if (this.varValues == null) {
            throw new CommandExecutionException("No loop parameters defined!");
        }
        assert (this.bodyLines != null);
        for (int i = 0; i < this.varValues.length; ++i) {
            this.properties.setProperty(this.varName, this.varValues[i]);
            log.finest("Set " + this.varName + " to " + this.varValues[i]);
            StringBufferInputStream is = ForeachCommand.generateInputStream(this.bodyLines);
            try {
                this.application.runScript(is);
                continue;
            }
            catch (CommandException ce) {
                throw new CommandExecutionException(ce.getMessage());
            }
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 3) {
            throw new CommandExecutionException(this.helpOutput());
        }
        assert (this.getParameter(0) instanceof StringParameter);
        this.varName = ((StringParameter)this.getParameter(0)).getValue();
        int numValues = this.getParameterCount() - 3;
        this.varValues = new String[numValues];
        String openBracketName = ((StringParameter)this.getParameter(1)).getValue();
        if (!BRACKET_OPEN.equals(openBracketName)) {
            throw new CommandExecutionException("Syntax error in for loop. Found " + openBracketName + " instead of \"(\". Example of correct usage: for varname in ( 1 2 3 ) echo end");
        }
        String closingName = ((StringParameter)this.getParameter(this.getParameterCount() - 1)).getValue();
        if (!BRACKET_CLOSE.equals(closingName)) {
            throw new CommandExecutionException("Syntax error in for loop. Found " + closingName + " instead of \")\". Example of correct usage: for varname in ( 1 2 3 ) echo end");
        }
        for (int i = 0; i < this.varValues.length; ++i) {
            this.varValues[i] = ((StringParameter)this.getParameter(i + 2)).getValue();
            log.fine("Set : " + this.varValues[i]);
        }
    }

    public void setBodyLines(String[] bodyLines) {
        assert (bodyLines != null);
        this.bodyLines = bodyLines;
    }
}

