/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandApplication;
import commandtools.CommandException;
import commandtools.CommandExecutionException;
import commandtools.Interpreter;
import commandtools.PackageConstants;
import commandtools.StringParameter;
import java.io.FileInputStream;
import java.io.IOException;

public class SourceCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "source";
    private String fileName;
    private CommandApplication application;

    public SourceCommand(CommandApplication application) {
        super(COMMAND_NAME);
        this.application = application;
    }

    @Override
    public Object cloneDeep() {
        SourceCommand command = new SourceCommand(this.application);
        command.fileName = this.fileName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    public String helpOutput() {
        return "Reads and executes script file. Correct usage: source filename";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"source\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " FILENAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Source command reads and executes script file." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.application != null);
        this.prepareReadout();
        try {
            FileInputStream is = new FileInputStream(this.fileName);
            this.application.runScript(is);
        }
        catch (IOException exc) {
            throw new CommandExecutionException("Error opening file " + this.fileName);
        }
        catch (CommandException ce) {
            throw new CommandExecutionException(ce.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 1) {
            throw new CommandExecutionException(this.helpOutput());
        }
        assert (this.getParameter(0) instanceof StringParameter);
        StringParameter stringParameter = (StringParameter)this.getParameter(0);
        this.fileName = stringParameter.getValue();
        Interpreter interpreter = this.application.getInterpreter();
        for (int i = 1; i < this.getParameterCount(); ++i) {
            String varName = "" + i;
            String value = ((StringParameter)this.getParameter(i)).getValue();
            System.out.println("# Setting variable " + varName + " to " + value);
            interpreter.setVariable(varName, value);
        }
    }
}

