/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import generaltools.ApplicationBugException;
import graphtools.DnaJunction;
import graphtools.DnaJunctionImp;
import graphtools.DnaJunctionSet;
import graphtools.DnaJunctionSetImp;
import graphtools.GraphBase;
import graphtools.IntPair;
import graphtools.IntegerList;
import graphtools.IntegerListList;
import graphtools.PathTools;
import java.util.logging.Logger;

public class DnaJunctionSetTools {
    public static int verboseLevel = 0;
    public static Logger log = Logger.getLogger("NanoTiler_debug");

    public static DnaJunction generateJunction(GraphBase graph, int nodeId) {
        return new DnaJunctionImp(graph.getConnections(nodeId).size());
    }

    public static DnaJunction generateRandomJunction(GraphBase graph, int nodeId) {
        DnaJunctionImp junction = new DnaJunctionImp(graph.getConnections(nodeId).size());
        junction.setRandom();
        return junction;
    }

    public static DnaJunctionSet generateJunctionSet(GraphBase graph) {
        DnaJunctionSetImp junctionSet = new DnaJunctionSetImp();
        for (int i = 0; i < graph.getNodeCount(); ++i) {
            int numConn = graph.getConnections(i).size();
            if (numConn < 2) {
                log.warning("graph node with " + numConn + " connections detected: " + i + "  " + graph.getConnections(i));
                continue;
            }
            junctionSet.add(DnaJunctionSetTools.generateJunction(graph, i));
        }
        return junctionSet;
    }

    public static DnaJunctionSet generateRandomJunctionSet(GraphBase graph) {
        DnaJunctionSetImp junctionSet = new DnaJunctionSetImp();
        for (int i = 0; i < graph.getNodeCount(); ++i) {
            int numConn = graph.getConnections(i).size();
            if (numConn < 2) {
                log.warning("graph node with " + numConn + " connections detected: " + i + "  " + graph.getConnections(i));
                continue;
            }
            junctionSet.add(DnaJunctionSetTools.generateRandomJunction(graph, i));
        }
        return junctionSet;
    }

    public static IntegerList generateEdgePath(IntPair startEdge, GraphBase graph, DnaJunctionSet junctions) {
        IntegerList result = new IntegerList();
        result.add(startEdge.getFirst());
        result.add(startEdge.getSecond());
        int oldNode = startEdge.getFirst();
        int currentNode = startEdge.getSecond();
        if (verboseLevel > 1) {
            log.fine("Starting generateEdgePath!");
            log.fine("starting from nodes " + oldNode + " " + currentNode);
        }
        IntPair currentEdge = new IntPair(0, 0);
        while (result.size() > 0) {
            currentEdge.setFirst(oldNode);
            currentEdge.setSecond(currentNode);
            int edgeId = graph.nodeIndexOf(currentEdge, currentNode);
            if (edgeId == -1) {
                throw new ApplicationBugException("Internal error (1) in generateEdgePath");
            }
            int newEdgeId = junctions.getJunction(currentNode).get3PrimeConnection(edgeId);
            IntPair newEdge = graph.getNodeEdge(newEdgeId, currentNode);
            int newNode = newEdge.getFirst();
            if (newNode == currentNode) {
                newNode = newEdge.getSecond();
            }
            if (verboseLevel > 1) {
                log.fine("Current Node, oldNode, newNode, edgeId: " + currentNode + " " + oldNode + " " + newNode + " " + edgeId);
            }
            if (result.contains(newNode)) {
                if (result.size() > 2) {
                    result.add(newNode);
                    if (verboseLevel > 1) {
                        log.fine("Returned path: " + result);
                    }
                    return result;
                }
                log.warning("bad path detected!  path so far: " + result + " new node: " + newNode);
                return result;
            }
            result.add(newNode);
            oldNode = currentNode;
            currentNode = newNode;
        }
        if (verboseLevel > 1) {
            log.fine("Finished generateEdgePath: " + result);
        }
        return result;
    }

    public static boolean containsEdge(IntegerList path, IntPair edge) {
        if (path.get(path.size() - 1) == edge.getFirst() && path.get(0) == edge.getSecond()) {
            return true;
        }
        for (int i = 1; i < path.size(); ++i) {
            if (path.get(i - 1) != edge.getFirst() || path.get(i) != edge.getSecond()) continue;
            return true;
        }
        return false;
    }

    public static boolean isEdgeFree(IntPair edge, IntegerListList paths) {
        int occurence = 0;
        for (int i = 0; i < paths.size(); ++i) {
            if (!DnaJunctionSetTools.containsEdge(paths.get(i), edge) || ++occurence <= 1) continue;
            return false;
        }
        return true;
    }

    public static int countEdgeOccurence(IntPair edge, IntegerListList paths) {
        int occurence = 0;
        for (int i = 0; i < paths.size(); ++i) {
            if (!DnaJunctionSetTools.containsEdge(paths.get(i), edge)) continue;
            ++occurence;
        }
        return occurence;
    }

    public static boolean isCoveringPathSet(IntegerListList paths, GraphBase graph) {
        for (int i = 0; i < graph.getEdgeCount(); ++i) {
            if (DnaJunctionSetTools.countEdgeOccurence(graph.getEdge(i), paths) == 1 && DnaJunctionSetTools.countEdgeOccurence(graph.getEdge(i).reverse(), paths) == 1) continue;
            return false;
        }
        return true;
    }

    public static IntegerListList generatePaths(GraphBase graph, DnaJunctionSet junctions) {
        IntegerListList result = new IntegerListList();
        for (int i = 0; i < graph.getEdgeCount(); ++i) {
            int j;
            IntegerList subPath;
            boolean found;
            int currLen;
            IntegerList path;
            IntPair edge;
            if (verboseLevel > 1) {
                log.fine("generatePaths iteration " + i);
                log.fine("working on edge " + i);
                log.fine("Result so far: " + result);
            }
            if (DnaJunctionSetTools.isEdgeFree(edge = graph.getEdge(i), result) && (path = DnaJunctionSetTools.generateEdgePath(edge, graph, junctions)) != null && path.size() > 1) {
                currLen = path.size();
                found = false;
                block1: do {
                    found = false;
                    subPath = path.subset(0, currLen);
                    for (j = 0; j < result.size(); ++j) {
                        if (!PathTools.isOverlapping(subPath, result.get(j))) continue;
                        found = true;
                        if (verboseLevel <= 1) continue block1;
                        log.fine("sub path is overlapping: " + subPath + " ; " + result.get(j));
                        continue block1;
                    }
                } while (found && currLen-- > 1);
                if (!found && currLen > 1) {
                    if (verboseLevel > 1) {
                        log.fine("found total path: " + path + " length: " + currLen);
                        log.fine("adding path: " + path.subset(0, currLen));
                    }
                    result.add(path.subset(0, currLen));
                } else if (verboseLevel > 1) {
                    log.fine("not adding path because it already exists: " + path);
                }
            }
            if (!DnaJunctionSetTools.isEdgeFree(edge = edge.reverse(), result) || (path = DnaJunctionSetTools.generateEdgePath(edge, graph, junctions)) == null) continue;
            currLen = path.size();
            found = false;
            block3: do {
                found = false;
                subPath = path.subset(0, currLen);
                for (j = 0; j < result.size(); ++j) {
                    if (!PathTools.isOverlapping(subPath, result.get(j))) continue;
                    found = true;
                    if (verboseLevel <= 1) continue block3;
                    log.fine("sub path 2 is overlapping: " + subPath + " ; " + result.get(j));
                    continue block3;
                }
            } while (found && currLen-- > 1);
            if (!found && currLen > 1) {
                if (verboseLevel > 1) {
                    log.fine("found total path: " + path + " length: " + currLen);
                    log.fine("adding path: " + path.subset(0, currLen));
                }
                result.add(path.subset(0, currLen));
                continue;
            }
            if (verboseLevel <= 1) continue;
            log.fine("not adding path because it already exists: " + path);
        }
        return result;
    }
}

