/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import generaltools.TestTools;
import graphtools.IntegerArrayConstraint;
import graphtools.IntegerPermutator;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.testng.annotations.Test;

public class MappedIntegerPermutator
implements IntegerPermutator {
    private int[] positions;
    private int max;
    private List<IntegerArrayConstraint> constraints = new ArrayList<IntegerArrayConstraint>();

    public MappedIntegerPermutator() {
        this(1, 1);
    }

    public MappedIntegerPermutator(int fromLen, int toLen) {
        assert (fromLen > 0);
        assert (toLen >= fromLen);
        this.positions = new int[fromLen];
        this.max = toLen;
        this.reset();
        assert (this.validate());
    }

    @Override
    public void addConstraint(IntegerArrayConstraint constraint) {
        assert (false);
        this.constraints.add(constraint);
    }

    @Override
    public Object clone() {
        throw new RuntimeException("clone method not supported.");
    }

    @Override
    public boolean hasNext() {
        for (int i = 0; i < this.positions.length; ++i) {
            if (this.positions[i] >= this.max - i - 1) continue;
            return true;
        }
        return false;
    }

    public boolean incAt(int pos) {
        int pc;
        if (pos >= this.positions.length) {
            return false;
        }
        int n = pc = pos;
        this.positions[n] = this.positions[n] + 1;
        if (this.positions[pc] >= this.max - pc && pos + 1 < this.positions.length) {
            boolean tmpResult = this.incAt(pos + 1);
            if (!tmpResult) {
                return false;
            }
            for (int i = pc; i >= 0; --i) {
                this.positions[i] = this.positions[i + 1] + 1;
            }
        }
        return true;
    }

    @Override
    public boolean inc() {
        assert (this.validate());
        boolean expNext = this.hasNext();
        if (!expNext) {
            return false;
        }
        boolean result = this.incAt(0);
        return result;
    }

    public void setPositions(int[] positions) {
        assert (this.positions.length == positions.length);
        this.positions = positions;
        assert (this.validate());
    }

    private void printVec(PrintStream ps, int[] a) {
        for (int i = 0; i < this.positions.length; ++i) {
            ps.print(" " + this.positions[i]);
        }
        ps.println();
    }

    @Override
    public int[] get() {
        return this.positions;
    }

    @Override
    public BigInteger getTotal() {
        assert (false);
        return null;
    }

    @Override
    public int[] next() {
        this.inc();
        return this.get();
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.positions.length; ++i) {
            this.positions[this.positions.length - i - 1] = i;
        }
        assert (this.validate());
    }

    @Override
    public int size() {
        return this.positions.length;
    }

    @Override
    public boolean validate() {
        for (int i = 0; i < this.positions.length; ++i) {
            if (this.positions[i] < 0 || this.positions[i] >= this.max) {
                return false;
            }
            if (i <= 0 || this.positions[i] < this.positions[i - 1]) continue;
            return false;
        }
        return true;
    }

    @Test(groups={"new"})
    public void testMappedIntegerPermutator() {
        String methodName = "testMappedIntegerPermutator";
        System.out.println(TestTools.generateMethodHeader(methodName));
        MappedIntegerPermutator gen = new MappedIntegerPermutator(4, 6);
        int count = 0;
        System.out.println("Results of MappedIntegerPermutator");
        do {
            ++count;
            int[] x = gen.get();
            assert (gen.validate());
            System.out.print("" + count + " : ");
            for (int i = 0; i < x.length; ++i) {
                System.out.print(" " + x[i]);
            }
            System.out.println();
        } while (gen.hasNext() && gen.next() != null);
    }
}

