/*
 * Decompiled with CFR 0.152.
 */
package numerictools;

import generaltools.ParsingException;
import generaltools.Randomizer;
import generaltools.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.testng.annotations.Test;

public class DoubleArrayTools {
    public static int chooseRouletteWheel(double[] pVec) {
        assert (pVec.length > 0);
        Random rnd = Randomizer.getInstance();
        if (pVec.length == 1) {
            return 0;
        }
        double totalSum = DoubleArrayTools.computeSum(pVec);
        assert (totalSum > 0.0);
        double y = rnd.nextDouble() * totalSum;
        double sum = 0.0;
        int result = 0;
        boolean found = false;
        for (int i = 0; i < pVec.length; ++i) {
            assert (pVec[i] >= 0.0);
            if (y >= sum && y <= sum + pVec[i]) {
                result = i;
                found = true;
                break;
            }
            sum += pVec[i];
        }
        assert (found);
        assert (result < pVec.length);
        return result;
    }

    public static void writeArray(PrintStream ps, double[] ary) {
        ps.print("" + ary.length + " ");
        for (int i = 0; i < ary.length; ++i) {
            ps.print(" " + ary[i]);
        }
        ps.println("");
    }

    private static double[] parseVector(String line) throws ParsingException {
        String[] words = line.trim().split(" ");
        double[] result = new double[words.length];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = Double.parseDouble(words[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new ParsingException("Error parsing word " + (i + 1) + " " + nfe.getMessage());
            }
        }
        return result;
    }

    public static double[][] readMatrix(InputStream is) throws IOException, ParsingException {
        String[] lines = StringTools.readAllLines(is);
        double[][] result = new double[lines.length][];
        for (int i = 0; i < result.length; ++i) {
            double[] v = DoubleArrayTools.parseVector(lines[i]);
            result[i] = v;
        }
        return result;
    }

    public static void writeMatrix(PrintStream ps, double[][] ary) {
        for (int i = 0; i < ary.length; ++i) {
            for (int j = 0; j < ary[i].length; ++j) {
                ps.print("" + ary[i][j] + " ");
            }
            ps.println("");
        }
    }

    public static double[][] transpose(double[][] mtx) {
        int rows = mtx.length;
        int cols = mtx[0].length;
        double[][] result = new double[cols][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                result[j][i] = mtx[i][j];
            }
        }
        return result;
    }

    public static double computeSum(double[] ary) {
        double result = 0.0;
        for (int i = 0; i < ary.length; ++i) {
            result += ary[i];
        }
        return result;
    }

    public static double[] getColumn(double[][] matrix, int n) {
        double[] col = new double[matrix.length];
        for (int i = 0; i < col.length; ++i) {
            col[i] = matrix[i][n];
        }
        return col;
    }

    public static int findHighestElement(double[] ary) {
        assert (ary.length > 0);
        int bestId = 0;
        for (int i = 1; i < ary.length; ++i) {
            if (!(ary[i] > ary[bestId])) continue;
            bestId = i;
        }
        assert (bestId < ary.length);
        return bestId;
    }

    public static double scoreOverlap(List<Double> highScores, List<Double> lowScores) {
        int i;
        assert (highScores != null);
        assert (highScores.size() > 0);
        assert (lowScores != null);
        assert (lowScores.size() > 0);
        Collections.sort(highScores);
        Collections.sort(lowScores);
        double lowestFromHigh = highScores.get(0);
        double highestFromLow = lowScores.get(lowScores.size() - 1);
        double result = 0.0;
        for (i = 0; i < highScores.size() && highScores.get(i) < highestFromLow; ++i) {
            result += highestFromLow - highScores.get(i);
        }
        for (i = lowScores.size() - 1; i >= 0 && lowScores.get(i) > lowestFromHigh; --i) {
            result += lowScores.get(i) - lowestFromHigh;
        }
        return result;
    }

    @Test(groups={"new"})
    public void testScoreOverlap() {
        ArrayList<Double> highScores = new ArrayList<Double>();
        ArrayList<Double> lowScores = new ArrayList<Double>();
        ArrayList<Double> vlowScores = new ArrayList<Double>();
        highScores.add(0.0);
        highScores.add(1.0);
        highScores.add(2.0);
        highScores.add(3.0);
        highScores.add(4.0);
        lowScores.add(2.0);
        lowScores.add(1.0);
        lowScores.add(0.0);
        lowScores.add(-1.0);
        lowScores.add(-2.0);
        vlowScores.add(0.0);
        vlowScores.add(-1.0);
        vlowScores.add(-2.0);
        vlowScores.add(-3.0);
        vlowScores.add(-3.0);
        assert (Math.abs(DoubleArrayTools.scoreOverlap(highScores, lowScores) - 6.0) < 0.01);
        assert (Math.abs(DoubleArrayTools.scoreOverlap(highScores, vlowScores)) < 0.01);
    }
}

