/*
 * Decompiled with CFR 0.152.
 */
package numerictools;

public class DoubleTools {
    public static final double REASONABLE_LIMIT = 1.0E10;

    public static boolean isReasonable(double d) {
        return DoubleTools.isValid(d) && Math.abs(d) < 1.0E10;
    }

    public static boolean isValid(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d);
    }

    public static boolean isValidAndPositive(double d) {
        return DoubleTools.isValid(d) && d > 0.0;
    }

    public static boolean isValidAndNotNegative(double d) {
        return DoubleTools.isValid(d) && d >= 0.0;
    }
}

