/*
 * Decompiled with CFR 0.152.
 */
package numerictools;

import generaltools.Randomizer;
import java.util.Random;
import java.util.logging.Logger;
import numerictools.OptimizationNDResult;
import numerictools.PotentialND;
import numerictools.PotentialNDOptimizer;
import numerictools.SimpleOptimizationNDResult;

public class SimulatedAnnealingOptimizer
implements PotentialNDOptimizer {
    private int iterMax = 1000;
    private double stepWidth = 1.0;
    private boolean minimize = true;
    private Random rand = Randomizer.getInstance();
    public int verboseLevel = 1;
    private Logger log = Logger.getLogger("NanoTiler_debug");
    public double decay = 0.999;
    public double[] stepScalings = null;

    double computeRandomPosition(double x, double step) {
        return x + this.rand.nextGaussian() * step;
    }

    double[] generateNewPosition(double[] position) {
        double[] newPos = new double[position.length];
        for (int i = 0; i < position.length; ++i) {
            double step = this.stepWidth;
            if (this.stepScalings != null) {
                step *= this.stepScalings[i];
            }
            newPos[i] = this.computeRandomPosition(position[i], step);
        }
        return newPos;
    }

    @Override
    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void setIterMax(int n) {
        this.iterMax = n;
    }

    public void setStepWidth(double x) {
        this.stepWidth = x;
    }

    @Override
    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
    }

    @Override
    public OptimizationNDResult optimize(PotentialND potential, double[] startPos) {
        int dim = startPos.length;
        SimpleOptimizationNDResult result = new SimpleOptimizationNDResult(dim);
        result.bestValue = potential.getValue(startPos);
        result.bestPosition = startPos;
        if (this.verboseLevel > 0) {
            this.log.fine("Starting Simulated annealing optimization at value and position: " + result.bestValue);
        }
        for (int iter = 0; iter < this.iterMax; ++iter) {
            double[] newPosition = this.generateNewPosition(result.bestPosition);
            double newVal = potential.getValue(newPosition);
            if (this.minimize) {
                if (newVal < result.bestValue) {
                    result.bestValue = newVal;
                    result.bestPosition = newPosition;
                    result.stepCount = iter;
                    if (this.verboseLevel > 1) {
                        this.log.fine("New best value and position: " + newVal);
                        this.log.fine("Iteration: " + iter + " currently best: " + result);
                    }
                }
            } else if (newVal > result.bestValue) {
                result.bestValue = newVal;
                result.bestPosition = newPosition;
                result.stepCount = iter;
                if (this.verboseLevel > 1) {
                    this.log.fine("New best value and position: " + newVal);
                    this.log.fine("Iteration: " + iter + " currently best: " + result);
                }
            }
            this.stepWidth *= this.decay;
        }
        if (this.verboseLevel > 0) {
            this.log.fine("SimulatedAnnealingOptimizer: Finishing optimization at value and position: " + result.bestValue);
        }
        return result;
    }
}

