/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.io.PrintStream;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.BridgeItController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class BridgeAllCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "bridgeall";
    private Object3DGraphController controller;
    private double angleWeight = 10.0;
    private String origName;
    private String filePrefix = "bridge_";
    private String rootName = "root";
    private int solutionId = 10;
    private int helixAlgorithm = 1;
    private PrintStream ps;
    private double collisionDistance = 2.0;
    private double rms = 3.0;
    private int lenMax = 3;

    public BridgeAllCommand(PrintStream ps, Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.ps = ps;
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        BridgeAllCommand command = new BridgeAllCommand(this.ps, this.controller);
        command.angleWeight = this.angleWeight;
        command.collisionDistance = this.collisionDistance;
        command.origName = this.origName;
        command.filePrefix = this.filePrefix;
        command.rootName = this.rootName;
        command.solutionId = this.solutionId;
        command.helixAlgorithm = this.helixAlgorithm;
        command.rms = this.rms;
        command.lenMax = this.lenMax;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: bridgeall name1 [angle=WEIGHT] [coll=VALUE] [combined=false|true][l=NUMBER] [n=NUMBER] [prefix=NAME] [root=NAME] [rms=VALUE]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"bridgeall\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " OBJECTNAME1 OBJECTNAME2 [angle=WEIGHT] [l=NUMBER] [n=NUMBER] [prefix=NAME] [root=NAME] [rms=VALUE]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     bridgeall command attempts to find bridging fragments between all strands of a substree";
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        this.ps.println("Calling controller.bridgeIt with " + this.origName);
        try {
            int numBridges = this.controller.bridgeAllStrands(this.origName, this.rootName);
            this.ps.println("Number of placed bridges: " + numBridges);
        }
        catch (Object3DGraphControllerException oce) {
            throw new CommandExecutionException("Error in bridgeall command: " + oce.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter rootPar;
        StringParameter pref;
        if (this.getParameterCount() > 0) {
            StringParameter p0 = (StringParameter)this.getParameter(0);
            this.origName = p0.getValue();
        }
        if ((pref = (StringParameter)this.getParameter("prefix")) != null) {
            this.filePrefix = pref.getValue();
        }
        if ((rootPar = (StringParameter)this.getParameter("root")) != null) {
            this.rootName = rootPar.getValue();
        }
        try {
            StringParameter angpar;
            StringParameter collpar;
            StringParameter rpar;
            StringParameter npar;
            StringParameter lpar;
            StringParameter apar = (StringParameter)this.getParameter("a");
            if (apar != null) {
                this.helixAlgorithm = Integer.parseInt(apar.getValue());
                if (!BridgeItController.validateHelixAlgorithm(this.helixAlgorithm)) {
                    throw new CommandExecutionException("Unknown helix algorithm id: " + this.helixAlgorithm);
                }
            }
            if ((lpar = (StringParameter)this.getParameter("max")) != null) {
                this.lenMax = Integer.parseInt(lpar.getValue());
            }
            if ((npar = (StringParameter)this.getParameter("n")) != null) {
                this.solutionId = Integer.parseInt(npar.getValue());
            }
            if ((rpar = (StringParameter)this.getParameter("rms")) != null) {
                this.rms = Double.parseDouble(rpar.getValue());
            }
            if ((collpar = (StringParameter)this.getParameter("coll")) != null) {
                this.collisionDistance = Double.parseDouble(collpar.getValue());
            }
            if ((angpar = (StringParameter)this.getParameter("angle")) != null) {
                this.angleWeight = Double.parseDouble(angpar.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Could not parse number: " + nfe.getMessage());
        }
    }
}

