/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.io.PrintStream;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;

public class DistanceCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "dist";
    private Object3DGraphController controller;
    private String origName;
    private String newParentName;
    private PrintStream ps;
    private static double distance;

    public DistanceCommand(PrintStream ps, Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.ps = ps;
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        DistanceCommand command = new DistanceCommand(this.ps, this.controller);
        command.origName = this.origName;
        command.newParentName = this.newParentName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: dist name1 name2";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"dist\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " OBJECTNAME1 OBJECTNAME2" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Distance command gives the distance between two objects." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            distance = this.controller.getGraph().computeDistance(this.origName, this.newParentName);
            Object3D obj1 = this.controller.getGraph().findByFullName(this.origName);
            Object3D obj2 = this.controller.getGraph().findByFullName(this.newParentName);
            Vector3D distVec = obj2.getPosition().minus(obj1.getPosition());
            this.ps.println(distance);
            this.ps.println(" Position 1: " + obj1.getPosition() + " Position 2: " + obj2.getPosition() + " Distance vector: " + distVec);
            this.resultProperties.setProperty(COMMAND_NAME, "" + distance);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 2) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.origName = p0.getValue();
        StringParameter p1 = (StringParameter)this.getParameter(1);
        this.newParentName = p1.getValue();
    }

    public double getDistance() {
        return distance;
    }
}

