/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.HelixParameters;
import tools3d.CoordinateSystem;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;

public class GenerateHelixCommand
extends AbstractCommand {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final String COMMAND_NAME = "genhelix";
    private String helixRootName = "root";
    private String name1;
    private String name2;
    private boolean propagate = true;
    private String bases = "GC";
    private int iterMax = 10000;
    private double rmsLimit = 5.0;
    private double angleLimit = 0.7853981633974483;
    private int numBasePairs = 10;
    private Object3DGraphController controller;
    private Vector3D position = new Vector3D(0.0, 0.0, 0.0);
    private Vector3D vx = new Vector3D(1.0, 0.0, 0.0);
    private Vector3D vy = new Vector3D(0.0, 1.0, 0.0);
    private String name = "helix";
    private HelixParameters helixParameters = new HelixParameters();

    public GenerateHelixCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        GenerateHelixCommand command = new GenerateHelixCommand(this.controller);
        command.name1 = this.name1;
        command.name2 = this.name2;
        command.name = this.name;
        command.helixRootName = this.helixRootName;
        command.rmsLimit = this.rmsLimit;
        command.angleLimit = this.angleLimit;
        command.propagate = this.propagate;
        command.helixParameters = new HelixParameters(this.helixParameters);
        return command;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        FitParameters stemFitParameters = new FitParameters(this.rmsLimit, this.angleLimit);
        stemFitParameters.setIterMax(this.iterMax);
        Properties properties = new Properties();
        try {
            char c1 = this.bases.charAt(0);
            char c2 = this.bases.charAt(1);
            if (this.name1 != null && this.name1.length() > 0) {
                if (this.name2 != null && this.name2.length() > 0) {
                    if (this.getParameter("bp") == null) {
                        this.numBasePairs = -1;
                    }
                    this.controller.generateHelix(this.name1, this.name2, c1, c2, stemFitParameters, this.helixRootName, this.numBasePairs, this.name);
                } else {
                    this.controller.generateHelix(this.name1, c1, c2, this.helixRootName, this.numBasePairs, this.name, this.propagate);
                }
            } else {
                CoordinateSystem3D cs = new CoordinateSystem3D(this.position, this.vx, this.vy);
                this.controller.generateIsolatedHelix(cs, this.helixParameters, c1, c2, this.helixRootName, this.name, this.numBasePairs);
            }
        }
        catch (FittingException fe) {
            throw new CommandExecutionException("Bad helix fit! " + fe.getMessage());
        }
        catch (Object3DGraphControllerException gce) {
            throw new CommandExecutionException(gce.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private boolean checkBase(char c) {
        switch (c) {
            case 'A': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'N': {
                return false;
            }
            case 'X': {
                return false;
            }
        }
        return false;
    }

    private boolean checkBases(String bases) {
        if (bases == null || bases.length() != 2) {
            return false;
        }
        return this.checkBase(bases.charAt(0)) && this.checkBase(bases.charAt(1));
    }

    private CoordinateSystem parseDeformation(String def) throws CommandExecutionException, NumberFormatException {
        String[] words = def.split(",");
        if (words.length != 9 && words.length != 3) {
            throw new CommandExecutionException("Error parsing deformation matrix parameters! Format: def=px,py,pz or def=px,py,pz,yx,yy,yz,zx,zy,zz");
        }
        Vector3D ex = new Vector3D(1.0, 0.0, 0.0);
        Vector3D ey = new Vector3D(0.0, 1.0, 0.0);
        Vector3D pos = new Vector3D(0.0, 0.0, 0.0);
        pos.setX(Double.parseDouble(words[0]));
        pos.setY(Double.parseDouble(words[1]));
        pos.setZ(Double.parseDouble(words[2]));
        if (words.length == 9) {
            ex.setX(Double.parseDouble(words[3]));
            ex.setY(Double.parseDouble(words[4]));
            ex.setZ(Double.parseDouble(words[5]));
            ey.setX(Double.parseDouble(words[6]));
            ey.setY(Double.parseDouble(words[7]));
            ey.setZ(Double.parseDouble(words[8]));
        }
        return new CoordinateSystem3D(pos, ex, ey);
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameter("bp1") != null) {
            this.name1 = ((StringParameter)this.getParameter("bp1")).getValue();
        }
        if (this.getParameter("bp2") != null) {
            this.name2 = ((StringParameter)this.getParameter("bp2")).getValue();
        }
        if (this.getParameter("bd1") != null) {
            this.name1 = ((StringParameter)this.getParameter("bd1")).getValue();
        }
        if (this.getParameter("bd2") != null) {
            this.name2 = ((StringParameter)this.getParameter("bd2")).getValue();
        }
        try {
            Command basesParameter;
            Command defParameter;
            Command nameParameter;
            Command helixRootParameter;
            Command angleLimitParameter;
            Command rmsParameter;
            Command bpParameter = this.getParameter("bp");
            if (bpParameter != null) {
                this.numBasePairs = Integer.parseInt(((StringParameter)bpParameter).getValue());
            }
            if ((rmsParameter = this.getParameter("rms")) != null) {
                this.rmsLimit = Double.parseDouble(((StringParameter)rmsParameter).getValue());
            }
            if ((angleLimitParameter = this.getParameter("angle")) != null) {
                this.angleLimit = Math.PI / 180 * Double.parseDouble(((StringParameter)angleLimitParameter).getValue());
            }
            if ((helixRootParameter = this.getParameter("root")) != null) {
                this.helixRootName = ((StringParameter)helixRootParameter).getValue();
            }
            if ((nameParameter = this.getParameter("name")) != null) {
                this.name = ((StringParameter)nameParameter).getValue();
            }
            if ((defParameter = this.getParameter("def")) != null) {
                String defString = ((StringParameter)defParameter).getValue();
                this.helixParameters.setDeformation(this.parseDeformation(defString));
            }
            if ((basesParameter = this.getParameter("bases")) != null) {
                this.bases = ((StringParameter)basesParameter).getValue();
                if (!this.checkBases(this.bases)) {
                    throw new CommandExecutionException("Illegel base name definition. Must be to characters out of A,C,G,U. Typical example: bases=AU or bases=GC");
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Bad number format detected: " + nfe.getMessage());
        }
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"genhelix\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput() + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "    " + this.helpOutput() + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        return helpText;
    }

    private String helpOutput() {
        return "Generates helix between one, two or zero helix descriptors (\"BranchDescriptor3D\"). Correct usage: genhelix [bd1=helixdescriptor1 [bd2=helixdescriptor2] [rms=value] [angle=value] [root=name] [name=name] [bp=number] [def=px,py,pz[,xx,xy,xz,yx,yy,yz]]";
    }
}

