/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.ParsingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnamodel.DBElementConnectionDescriptor;
import rnadesign.rnamodel.DBElementDescriptor;
import rnadesign.rnamodel.GrowConnectivity;
import tools3d.Vector3D;

public class GrowCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "grow";
    private Object3DGraphController controller;
    private List<DBElementDescriptor> blockList = new ArrayList<DBElementDescriptor>();
    private List<DBElementConnectionDescriptor> connections = new ArrayList<DBElementConnectionDescriptor>();
    private boolean graphFlag = false;
    private String rootName = "root";
    private String nameBase = "g_";
    private Vector3D startPosition = new Vector3D(0.0, 0.0, 0.0);
    private int generationCount = 3;
    private boolean addHelicesFlag = true;
    private boolean avoidCollisionsFlag = true;
    private double ringClosureExportLimit = 15.0;
    private String ringClosureExportFileNameBase = "grow_ring";
    private double stemRmsLimit = 5.0;
    private Set<String> topologies = new HashSet<String>();
    private int sizeMax = -1;

    public GrowCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    private String getBlockString(DBElementDescriptor dbe) {
        char c = 'j';
        if (dbe.getType() == 1) {
            c = 'j';
        } else if (dbe.getType() == 2) {
            c = 'k';
        }
        String result = "" + c + "," + dbe.getOrder() + "," + (dbe.getId() + 1);
        log.finest("toString of " + dbe + " : " + result);
        return result;
    }

    public boolean isValid() {
        return this.blockList.size() > 0 && this.connections.size() > 0;
    }

    private String getConnectionString(DBElementConnectionDescriptor dbc) {
        int id1 = this.blockList.indexOf(dbc.getDescriptor1()) + 1;
        int id2 = this.blockList.indexOf(dbc.getDescriptor2()) + 1;
        String helixendName1 = dbc.getHelixendName1();
        String helixendName2 = dbc.getHelixendName2();
        int len = dbc.getBasePairCount();
        String result = "" + id1 + "," + id2 + "," + helixendName1 + "," + helixendName2 + "," + len;
        log.finest("toString of " + dbc + " : " + result);
        return result;
    }

    private String getBlocksString(List<DBElementDescriptor> dbes) {
        if (dbes.size() == 0) {
            return "";
        }
        String result = this.getBlockString(dbes.get(0));
        assert (result != null);
        if (result.equals("")) {
            log.warning("Weird block descriptor: " + dbes.get(0));
        }
        for (int i = 1; i < dbes.size(); ++i) {
            result = result + ";" + this.getBlockString(dbes.get(i));
        }
        return result;
    }

    private String getConnectionsString(List<DBElementConnectionDescriptor> dbes) {
        if (dbes.size() == 0) {
            return "";
        }
        String result = this.getConnectionString(dbes.get(0));
        for (int i = 1; i < dbes.size(); ++i) {
            result = result + ";" + this.getConnectionString(dbes.get(i));
        }
        return result;
    }

    private List<DBElementDescriptor> cloneBlockList() {
        ArrayList<DBElementDescriptor> result = new ArrayList<DBElementDescriptor>();
        for (int i = 0; i < this.blockList.size(); ++i) {
            result.add(this.blockList.get(i));
        }
        return result;
    }

    private List<DBElementConnectionDescriptor> cloneConnections() {
        ArrayList<DBElementConnectionDescriptor> result = new ArrayList<DBElementConnectionDescriptor>();
        for (int i = 0; i < this.connections.size(); ++i) {
            result.add(this.connections.get(i));
        }
        return result;
    }

    @Override
    public Object cloneDeep() {
        GrowCommand command = new GrowCommand(this.controller);
        command.blockList = this.cloneBlockList();
        command.connections = this.cloneConnections();
        command.graphFlag = this.graphFlag;
        command.rootName = new String(this.rootName);
        command.nameBase = new String(this.nameBase);
        command.startPosition = this.startPosition;
        command.generationCount = this.generationCount;
        command.addHelicesFlag = this.addHelicesFlag;
        command.avoidCollisionsFlag = this.avoidCollisionsFlag;
        command.ringClosureExportLimit = this.ringClosureExportLimit;
        command.ringClosureExportFileNameBase = this.ringClosureExportFileNameBase;
        command.stemRmsLimit = this.stemRmsLimit;
        command.topologies = this.topologies;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Simulated self-assembly of RNA building blocks. Correct usage: grow root=graphobjectname blocks=j|k,order,index[;j|k,order,index] connect=BLOCK_ID,HELIX_ID,BLOCK_ID,HELIX_ID,BASEPAIRCOUNT;BLOCK_ID,HELIX_ID,BLOCK_ID,HELIX_ID,BASEPAIRCOUNT [pos=x,y,z] [gen=number][graph=false|true] [helices=true|false][ring-export filename][ring-export-limit][size-max=value][steric=true|false][topologies=top1|top2|...]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"grow\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput() + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     places specified junction at certain position in space." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        log.info("Command grow called with parameters: " + this.toString());
        if (!this.isValid()) {
            throw new CommandExecutionException("Grow command parameters are not valid for execution: " + this.toString());
        }
        try {
            GrowConnectivity connectivity = new GrowConnectivity(this.blockList, this.connections, this.topologies, this.generationCount);
            connectivity.setGraphFlag(this.graphFlag);
            connectivity.setSizeMax(this.sizeMax);
            assert (this.topologies == null || this.topologies.size() == 0);
            assert (connectivity.getTopologies() == null || connectivity.getTopologies().size() == 0);
            this.resultProperties = this.controller.growBuildingBlocks(connectivity, this.rootName, this.nameBase, this.startPosition, this.addHelicesFlag, this.stemRmsLimit, this.avoidCollisionsFlag, this.ringClosureExportLimit, this.ringClosureExportFileNameBase);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void readoutBlock(String block, int descriptorId) throws CommandExecutionException {
        if (block == null || block.length() == 0) {
            throw new CommandExecutionException("Error parsing building blocks option. Insufficient block description.");
        }
        String[] words = block.split(",");
        if (words.length != 3) {
            throw new CommandExecutionException("Error parsing building block: 4 elements expected for each block descriptor.");
        }
        int blockType = 0;
        int id = 0;
        int order = 0;
        if (words[0].equals("j")) {
            blockType = 1;
        } else if (words[0].equals("k")) {
            blockType = 2;
        } else {
            throw new CommandExecutionException("Unknown building block type: " + words[0]);
        }
        try {
            order = Integer.parseInt(words[1]);
            id = Integer.parseInt(words[2]) - 1;
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Grow command: Error parsing number: " + nfe.getMessage());
        }
        DBElementDescriptor element = new DBElementDescriptor(order, id, blockType, descriptorId);
        this.blockList.add(element);
    }

    private void readoutBlocks(String blocks) throws CommandExecutionException {
        if (blocks == null || blocks.length() == 0) {
            throw new CommandExecutionException("Error parsing building blocks option.");
        }
        String[] words = blocks.split(";");
        for (int i = 0; i < words.length; ++i) {
            this.readoutBlock(words[i], i);
        }
    }

    private void readoutConnection(String connection) throws CommandExecutionException {
        assert (connection != null);
        String[] words = connection.split(",");
        if (words.length != 5 && words.length != 6) {
            throw new CommandExecutionException("5 or 6 elements expected in connect descriptor");
        }
        try {
            int id1 = Integer.parseInt(words[0]) - 1;
            int id2 = Integer.parseInt(words[1]) - 1;
            String helixendName1 = words[2];
            String helixendName2 = words[3];
            if (helixendName1.length() == 0 || helixendName2.length() == 0) {
                throw new CommandExecutionException("Undefined helix index in " + connection + " : " + helixendName1 + " " + helixendName2);
            }
            if (Character.isDigit(helixendName1.charAt(0))) {
                helixendName1 = "(hxend)" + helixendName1;
            }
            if (Character.isDigit(helixendName2.charAt(0))) {
                helixendName2 = "(hxend)" + helixendName2;
            }
            if (id1 < 0 || id1 >= this.blockList.size()) {
                throw new CommandExecutionException("Undefined block index in " + connection + " : " + id1);
            }
            if (id2 < 0 || id2 >= this.blockList.size()) {
                throw new CommandExecutionException("Undefined block index in " + connection + " : " + id2);
            }
            DBElementDescriptor descriptor1 = this.blockList.get(id1);
            DBElementDescriptor descriptor2 = this.blockList.get(id2);
            int basePairCount = Integer.parseInt(words[4]);
            int delayStage = 0;
            if (words.length > 5) {
                delayStage = Integer.parseInt(words[5]);
            }
            log.fine("Added descriptor " + this.connections.size() + " for ids: " + (id1 + 1) + " and " + (id2 + 1) + " " + helixendName1 + " " + helixendName2 + " bp: " + basePairCount + " delay: " + delayStage);
            DBElementConnectionDescriptor conn = new DBElementConnectionDescriptor(descriptor1, descriptor2, helixendName1, helixendName2, basePairCount);
            conn.setDelayStage(delayStage);
            this.connections.add(conn);
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Number format exception while parsing connect option in grow command: " + nfe.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException oobe) {
            throw new CommandExecutionException("Index of out bounds exception while parsing connect option in grow command: " + oobe.getMessage());
        }
    }

    private void readoutConnections(String connections) throws CommandExecutionException {
        if (connections == null || connections.length() == 0) {
            throw new CommandExecutionException("Error parsing connect option in grow command.");
        }
        String[] words = connections.split(";");
        for (int i = 0; i < words.length; ++i) {
            this.readoutConnection(words[i]);
        }
    }

    private Set<String> readoutTopologies(String value) {
        assert (false);
        assert (value != null);
        String[] topwords = value.split("|");
        HashSet<String> result = new HashSet<String>();
        for (String s : topwords) {
            if (s.length() <= 0) continue;
            result.add(s);
        }
        return result;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 0) {
            throw new CommandExecutionException(this.helpOutput());
        }
        try {
            StringParameter genName;
            StringParameter hName;
            StringParameter topologyParameter;
            StringParameter sizeMaxString;
            StringParameter stemRmsLimitName;
            StringParameter ringPdbLimitName;
            StringParameter pName;
            StringParameter pRoot;
            StringParameter pBlocks = (StringParameter)this.getParameter("blocks");
            if (pBlocks == null) {
                throw new CommandExecutionException("Building blocks have to be specified using the blocks option.");
            }
            this.readoutBlocks(pBlocks.getValue());
            StringParameter pConnect = (StringParameter)this.getParameter("connect");
            if (pConnect == null) {
                throw new CommandExecutionException("Building block connections have to be specified using the connect option.");
            }
            this.readoutConnections(pConnect.getValue());
            StringParameter graphPar = (StringParameter)this.getParameter("graph");
            if (graphPar != null) {
                this.graphFlag = graphPar.parseBoolean();
            }
            if ((pRoot = (StringParameter)this.getParameter("root")) != null) {
                this.rootName = pRoot.getValue();
            }
            if ((pName = (StringParameter)this.getParameter("name")) != null) {
                this.nameBase = pName.getValue();
            }
            StringParameter ringPdbName = (StringParameter)this.getParameter("ring-export");
            log.info("ringPdbName = " + ringPdbName);
            if (ringPdbName != null) {
                this.ringClosureExportFileNameBase = ringPdbName.getValue();
            }
            if ((ringPdbLimitName = (StringParameter)this.getParameter("ring-export-limit")) != null) {
                try {
                    this.ringClosureExportLimit = Double.parseDouble(ringPdbLimitName.getValue());
                }
                catch (NumberFormatException nfe) {
                    throw new CommandExecutionException("Number format exception while parsing ring closure export limit: " + nfe.getMessage());
                }
            }
            if ((stemRmsLimitName = (StringParameter)this.getParameter("stem-rms")) != null) {
                try {
                    this.stemRmsLimit = Double.parseDouble(stemRmsLimitName.getValue());
                }
                catch (NumberFormatException nfe) {
                    throw new CommandExecutionException("Number format exception while parsing stem RMS limit: " + nfe.getMessage());
                }
            }
            if ((sizeMaxString = (StringParameter)this.getParameter("size-max")) != null) {
                try {
                    this.sizeMax = Integer.parseInt(sizeMaxString.getValue());
                }
                catch (NumberFormatException nfe) {
                    throw new CommandExecutionException("Number format exception while parsing size-max parameter: " + nfe.getMessage());
                }
            }
            if ((topologyParameter = (StringParameter)this.getParameter("topologies")) != null) {
                this.topologies = this.readoutTopologies(topologyParameter.getValue());
            }
            if ((hName = (StringParameter)this.getParameter("helices")) != null) {
                this.addHelicesFlag = hName.parseBoolean();
            }
            if ((hName = (StringParameter)this.getParameter("steric")) != null) {
                this.avoidCollisionsFlag = hName.parseBoolean();
            }
            if ((genName = (StringParameter)this.getParameter("gen")) != null) {
                this.generationCount = Integer.parseInt(genName.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Number format exception while parsing number of base pairs (option bp): " + nfe.getMessage());
        }
        catch (ParsingException pe) {
            throw new CommandExecutionException("Parsing exception in grow command: " + pe.getMessage());
        }
    }

    private String boolString(boolean b) {
        if (b) {
            return "true";
        }
        return "false";
    }
}

