/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.ParsingException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.FragmentGridTiler;
import tools3d.Vector3D;
import tools3d.objects3d.Object3DIOException;

public class ImportCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "import";
    public static final String POINTS_EXTENSION = ".points";
    public static final String POINTS2_EXTENSION = ".points2";
    public static final String PDB_EXTENSION = ".pdb";
    private String fileName;
    private boolean findStemsFlag = false;
    private boolean addJunctionsFlag = true;
    private String importName;
    private int format = -1;
    private char sequenceChar = (char)78;
    private int rerunMax = -1;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private double scaleZ = 1.0;
    private double sx = 0.0;
    private double sy = 0.0;
    private double sz = 0.0;
    private boolean addStemsFlag = false;
    private boolean onlyFirstPathMode = false;
    private Object3DGraphController controller;
    private double stemAngleLimit = -1.0;
    private double junctionAngleLimit = -1.0;
    private double junctionAngleWeight = -1.0;
    private double stemRmsLimit = 3.0;
    private double junctionRmsLimit = 15.0;
    private static Set allowedParameterNames = ImportCommand.generateAllowedParameterNameSet();
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean residueRenumberMode = false;

    public ImportCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    private static Set generateAllowedParameterNameSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("");
        set.add("name");
        set.add("addjunctions");
        set.add("addstems");
        set.add("findstems");
        set.add("format");
        set.add("stemrms");
        set.add("junctionrms");
        set.add("stemangle");
        set.add("junctionangle");
        set.add("junctionangleweight");
        set.add("renumber");
        set.add("rerun");
        set.add("scale");
        set.add("scalex");
        set.add("scaley");
        set.add("scalez");
        return set;
    }

    @Override
    public Object cloneDeep() {
        ImportCommand command = new ImportCommand(this.controller);
        command.fileName = this.fileName;
        command.findStemsFlag = this.findStemsFlag;
        command.addJunctionsFlag = this.addJunctionsFlag;
        command.importName = this.importName;
        command.sequenceChar = this.sequenceChar;
        command.residueRenumberMode = this.residueRenumberMode;
        command.rerunMax = this.rerunMax;
        command.scaleX = this.scaleX;
        command.scaleY = this.scaleY;
        command.scaleZ = this.scaleZ;
        command.sx = this.sx;
        command.sy = this.sy;
        command.sz = this.sz;
        command.addStemsFlag = this.addStemsFlag;
        command.onlyFirstPathMode = this.onlyFirstPathMode;
        command.stemAngleLimit = this.stemAngleLimit;
        command.junctionAngleLimit = this.junctionAngleLimit;
        command.junctionAngleWeight = this.junctionAngleWeight;
        command.stemRmsLimit = this.stemRmsLimit;
        command.junctionRmsLimit = this.junctionRmsLimit;
        command.residueRenumberMode = this.residueRenumberMode;
        this.log.fine("Copying " + this.getParameterCount() + " parameters!");
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        this.log.info("Started ImportCommand.executeWithoutUndo");
        FragmentGridTiler fgTiler = this.controller.getFragmentGridTiler();
        try {
            FileInputStream fis = new FileInputStream(this.fileName);
            if (this.format < 0) {
                if (this.fileName.toLowerCase().endsWith(POINTS_EXTENSION)) {
                    this.format = 6;
                } else if (this.fileName.toLowerCase().endsWith(POINTS2_EXTENSION)) {
                    this.format = 7;
                } else if (this.fileName.toLowerCase().endsWith(PDB_EXTENSION)) {
                    this.format = 5;
                    if (this.residueRenumberMode) {
                        this.format = 9;
                    }
                } else {
                    throw new CommandExecutionException("Unknown import format extension: " + this.fileName);
                }
            }
            FitParameters stemFitParameters = fgTiler.getStemFitParameters();
            if (this.stemRmsLimit > 0.0) {
                stemFitParameters.setRmsLimit(this.stemRmsLimit);
            }
            if (this.stemAngleLimit > 0.0) {
                stemFitParameters.setAngleLimit(this.stemAngleLimit);
            }
            this.controller.getFragmentGridTiler().setStemFitParameters(stemFitParameters);
            FitParameters junctionFitParameters = fgTiler.getJunctionFitParameters();
            if (this.junctionAngleLimit > 0.0) {
                junctionFitParameters.setAngleLimit(this.junctionAngleLimit);
            }
            if (this.junctionAngleWeight >= 0.0) {
                junctionFitParameters.setAngleWeight(this.junctionAngleWeight);
                assert (junctionFitParameters.getAngleWeight() == this.junctionAngleWeight);
            } else {
                this.log.fine("Junction angle weight was not set: " + this.junctionAngleWeight);
            }
            if (this.junctionRmsLimit > 0.0) {
                junctionFitParameters.setRmsLimit(this.junctionRmsLimit);
                assert (junctionFitParameters.getRmsLimit() == this.junctionRmsLimit);
            }
            fgTiler.setJunctionFitParameters(junctionFitParameters);
            if (this.rerunMax > 0) {
                fgTiler.setRerunMax(this.rerunMax);
            }
            assert (fgTiler.getJunctionFitParameters() == junctionFitParameters);
            assert (this.controller.getFragmentGridTiler() == fgTiler);
            FitParameters juncFitTestPrm = this.controller.getFragmentGridTiler().getJunctionFitParameters();
            assert (this.junctionRmsLimit <= 0.0 || juncFitTestPrm.getRmsLimit() == this.junctionRmsLimit);
            if (this.getParameterCount() > 3) {
                this.log.info("Effective junction fit parameters: " + juncFitTestPrm + " should be: " + junctionFitParameters);
            } else {
                this.log.fine("Effective junction fit parameters: " + juncFitTestPrm + " should be: " + junctionFitParameters);
            }
            this.controller.readAndAdd(fis, this.importName, new Vector3D(this.scaleX, this.scaleY, this.scaleZ), new Vector3D(this.sx, this.sy, this.sz), this.format, this.addStemsFlag, this.sequenceChar, this.onlyFirstPathMode, this.findStemsFlag, this.addJunctionsFlag);
        }
        catch (Object3DIOException exc) {
            throw new CommandExecutionException("Error reading file: " + exc.getMessage());
        }
        catch (IOException exc) {
            throw new CommandExecutionException("Error opening file " + this.fileName);
        }
        this.log.info("Finished ImportCommand.executeWithoutUndo");
    }

    @Override
    public boolean isAllowedParameterName(String name) {
        if (name.equals("string")) {
            return true;
        }
        return allowedParameterNames.contains(name);
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    public String helpOutput() {
        return "Correct usage: import fileName [addstems=true|false][name=newname][addjunctions=true|false][findstems=false|true][format=rnaview|pdb|points|points2|renumber][junctionangle=value][junctionangleweight=value][junctionrms=value][renumber=true|false][rerun=number][scale=value][stemangle][stemrms=value]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"import\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " FILENAME [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Import command allows user to import a file." + PackageConstants.NEWLINE;
        helpText = helpText + "     TODO: Also, unnamed options are allowed.";
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     name=NAME" + PackageConstants.NEWLINE + "          Set the name of the imported file." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     addstems=BOOLEAN" + PackageConstants.NEWLINE + "          Synthesize stems for graph structure." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     findstems=BOOLEAN" + PackageConstants.NEWLINE + "          Find stems using atom coordinates. Default: false" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     addjunctions=BOOLEAN" + PackageConstants.NEWLINE + "       Add junctions using stems generated from atom coordinates." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     format=rnaview|pdb|points|points2|renumber" + PackageConstants.NEWLINE + "        Specificif format specification. rnaview: add RNAview info before PDB file (default), pdb: read normal pdb file without base pair info, points: read points file point2: read points2 file (not supported anymore), renumber: read Rnaview + PDB file, rename residues" + PackageConstants.NEWLINE;
        helpText = helpText + "     renumber=BOOLEAN" + PackageConstants.NEWLINE + "          if true, renumber residues while reading file." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     stemrms=NUM" + PackageConstants.NEWLINE + "          Set the stem RMS limit to NUM." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     junctionrms=NUM" + PackageConstants.NEWLINE + "          Set the junction RMS limit to NUM." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     stemangle=NUM" + PackageConstants.NEWLINE + "          Set the stem angle limit to NUM." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     junctionangle=NUM" + PackageConstants.NEWLINE + "          Set the junction angle limit to NUM." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     junctionangleweight=NUM" + PackageConstants.NEWLINE + "          Set the weight junction angle to NUM." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     rerun=NUM" + PackageConstants.NEWLINE + "          Set the number of reruns to try until entire graph is covered." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     scale=NUM" + PackageConstants.NEWLINE + "          Scale the entire imported file by NUM." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     scalex=NUM" + PackageConstants.NEWLINE + "          X scale factor." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     scaley=NUM" + PackageConstants.NEWLINE + "          Y scale factor." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     scalez=NUM" + PackageConstants.NEWLINE + "          Z scale factor." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    private int parseFormat(String s) throws ParsingException {
        assert (s != null);
        if (s.length() == 0) {
            throw new ParsingException("Error parsing empty string as import format string.");
        }
        if (Character.isDigit(s.charAt(0))) {
            try {
                int result = Integer.parseInt(s);
                return result;
            }
            catch (NumberFormatException nfe) {
                throw new ParsingException("Error parsing numerical import format: " + nfe.getMessage());
            }
        }
        if ((s = s.toLowerCase()).equals("rnaview")) {
            return 5;
        }
        if (s.equals("pdb")) {
            return 3;
        }
        if (s.equals("points")) {
            return 5;
        }
        if (s.equals("points2")) {
            return 5;
        }
        if (s.equals("renumber")) {
            return 9;
        }
        if (!s.equals("Some_rediciulus_value_as_workaround")) {
            throw new ParsingException("Could not interpret format idenfifier: " + s + " allowed: rnaview|pdb|points|points2|renumber");
        }
        assert (false);
        return -1;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 0) {
            throw new CommandExecutionException(this.helpOutput());
        }
        this.log.fine("Number of parameters: " + this.getParameterCount());
        for (int i = 0; i < this.getParameterCount(); ++i) {
            this.log.fine("Parameter: " + (i + 1) + this.getParameter(i));
        }
        if (!this.checkParameterNames()) {
            throw new CommandExecutionException("bad parameter names detected in import!");
        }
        assert (this.getParameterCount() > 0);
        assert (this.getParameter(0) instanceof StringParameter);
        try {
            Command rerunParameter;
            Command junctionAngleLimitParameter;
            Command junctionRmsLimitParameter;
            Command stemRmsLimitParameter;
            Command formatParameter;
            Command findStemsParameter;
            StringParameter stringParameter = (StringParameter)this.getParameter(0);
            this.fileName = stringParameter.getValue();
            Command nameParameter = this.getParameter("name");
            if (nameParameter != null) {
                assert (nameParameter instanceof StringParameter);
                this.importName = ((StringParameter)nameParameter).getValue();
            } else {
                this.importName = COMMAND_NAME;
            }
            StringParameter addStemsParameter = (StringParameter)this.getParameter("addstems");
            if (addStemsParameter != null) {
                String value = addStemsParameter.getValue().toLowerCase();
                if (value.equals("true")) {
                    this.addStemsFlag = true;
                } else if (value.equals("false")) {
                    this.addStemsFlag = false;
                } else {
                    throw new CommandExecutionException("bad syntax, expected addstems=true|false");
                }
                this.log.fine("Setting addstems parameter from " + addStemsParameter.getValue() + " to " + this.addStemsFlag);
            } else {
                this.log.fine("addstems parameter was not specified.");
            }
            Command addJunctionsParameter = this.getParameter("addjunctions");
            if (addJunctionsParameter != null) {
                this.addJunctionsFlag = ((StringParameter)addJunctionsParameter).parseBoolean();
            }
            if ((findStemsParameter = this.getParameter("findstems")) != null) {
                this.findStemsFlag = ((StringParameter)findStemsParameter).parseBoolean();
            }
            if ((formatParameter = this.getParameter("format")) != null) {
                this.format = this.parseFormat(((StringParameter)formatParameter).getValue());
            }
            if ((stemRmsLimitParameter = this.getParameter("stemrms")) != null) {
                this.stemRmsLimit = Double.parseDouble(((StringParameter)stemRmsLimitParameter).getValue());
                this.log.fine("stemrms is part of import command: " + this.stemRmsLimit);
            } else {
                this.log.fine("stemrms not part of import command");
            }
            Command renumberParameter = this.getParameter("renumber");
            if (renumberParameter != null) {
                String value = ((StringParameter)renumberParameter).getValue().toLowerCase();
                if (value.equals("true")) {
                    this.residueRenumberMode = true;
                } else if (value.equals("false")) {
                    this.residueRenumberMode = false;
                } else {
                    throw new CommandExecutionException("bad syntax, expected renumber=true|false");
                }
            }
            if ((junctionRmsLimitParameter = this.getParameter("junctionrms")) != null) {
                this.junctionRmsLimit = Double.parseDouble(((StringParameter)junctionRmsLimitParameter).getValue());
                this.log.fine("junctionrms is part of import command: " + this.junctionRmsLimit);
            } else {
                this.log.fine("Using default junction rms limit: " + this.junctionRmsLimit);
            }
            Command stemAngleLimitParameter = this.getParameter("stemangle");
            if (stemAngleLimitParameter != null) {
                this.stemAngleLimit = Math.PI / 180 * Double.parseDouble(((StringParameter)stemAngleLimitParameter).getValue());
                this.log.fine("stemangle is part of command: " + this.stemAngleLimit);
            }
            if ((junctionAngleLimitParameter = this.getParameter("junctionangle")) != null) {
                this.junctionAngleLimit = Math.PI / 180 * Double.parseDouble(((StringParameter)junctionAngleLimitParameter).getValue());
                this.log.fine("junctionangle is part of command: " + this.junctionAngleLimit);
            } else {
                this.log.fine("import : junctionangle not part of command.");
            }
            Command junctionAngleWeightParameter = this.getParameter("junctionangleweight");
            if (junctionAngleWeightParameter != null) {
                this.junctionAngleWeight = Double.parseDouble(((StringParameter)junctionAngleWeightParameter).getValue());
                this.log.fine("Setting junction angle weight to : " + this.junctionAngleWeight);
            } else {
                this.log.fine("import : junctionangleweight not part of command.");
            }
            Command scaleParameter = this.getParameter("scale");
            if (scaleParameter != null) {
                double scale = Double.parseDouble(((StringParameter)scaleParameter).getValue());
                if (scale <= 0.0) {
                    throw new CommandExecutionException("scale parameter must be greater zero!");
                }
                this.scaleX = scale;
                this.scaleY = scale;
                this.scaleZ = scale;
                this.log.fine("Import scale was set to: " + scale);
            } else {
                this.log.fine("scale is not part of command!");
            }
            scaleParameter = this.getParameter("scalex");
            if (scaleParameter != null) {
                this.scaleX = Double.parseDouble(((StringParameter)scaleParameter).getValue());
                if (this.scaleX <= 0.0) {
                    throw new CommandExecutionException("scale parameter must be greater zero!");
                }
            }
            if ((scaleParameter = this.getParameter("scaley")) != null) {
                this.scaleY = Double.parseDouble(((StringParameter)scaleParameter).getValue());
                if (this.scaleY <= 0.0) {
                    throw new CommandExecutionException("scale parameter must be greater zero!");
                }
            }
            if ((scaleParameter = this.getParameter("scalez")) != null) {
                this.scaleZ = Double.parseDouble(((StringParameter)scaleParameter).getValue());
                if (this.scaleZ <= 0.0) {
                    throw new CommandExecutionException("scale parameter must be greater zero!");
                }
            }
            if ((rerunParameter = this.getParameter("rerun")) != null) {
                this.rerunMax = Integer.parseInt(((StringParameter)rerunParameter).getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Number format exception! " + nfe.getMessage());
        }
        catch (ParsingException pe) {
            throw new CommandExecutionException("Parsing exception in import command: " + pe.getMessage());
        }
    }
}

