/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.io.PrintStream;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.BridgeItController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class JBridgeItCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "jbridgeit";
    private Object3DGraphController controller;
    private double angleWeight = 10.0;
    private String origName;
    private String filePrefix = "jbridge_";
    private String rootName = "root";
    private int solutionId = 10;
    private int helixAlgorithm = 1;
    private PrintStream ps;
    private double collisionDistance = 2.0;
    private double rms = 2.0;
    private int lenMin = 1;
    private int lenMax = 3;

    public JBridgeItCommand(PrintStream ps, Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.ps = ps;
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        JBridgeItCommand command = new JBridgeItCommand(this.ps, this.controller);
        command.angleWeight = this.angleWeight;
        command.collisionDistance = this.collisionDistance;
        command.origName = this.origName;
        command.filePrefix = this.filePrefix;
        command.rootName = this.rootName;
        command.solutionId = this.solutionId;
        command.helixAlgorithm = this.helixAlgorithm;
        command.rms = this.rms;
        command.lenMin = this.lenMin;
        command.lenMax = this.lenMax;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: jbridgeit JUNCTIONAME [angle=WEIGHT] [coll=VALUE] [combined=false|true][l=NUMBER] [min=NUMBER][n=NUMBER] [prefix=NAME] [root=NAME] [rms=VALUE]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"jbridgeit\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " JUNCTIONNAME [angle=WEIGHT] [l=NUMBER] [m=NUMBER][n=NUMBER] [prefix=NAME] [root=NAME] [rms=VALUE]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     bridgeit command attempts to find bridging fragments between strands that are connected with a junction link. The link has to be specified with a name, it could have been generated with the command genjunctionconstraint name=NAME." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "Options: " + PackageConstants.NEWLINE + "l=NUMBER : maximum length (nucleotides) of bridge" + "m=NUMBER : minimum length (nucleotides) of bridge";
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            this.ps.println("Calling controller.bridgeIt with junction " + this.origName);
            this.resultProperties = this.controller.jBridgeIt(this.origName, this.rootName, this.filePrefix, this.solutionId, this.rms, this.angleWeight, this.helixAlgorithm, this.lenMin, this.lenMax);
            this.ps.println(this.resultProperties);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter rootPar;
        if (this.getParameterCount() < 1) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.origName = p0.getValue();
        StringParameter pref = (StringParameter)this.getParameter("prefix");
        if (pref != null) {
            this.filePrefix = pref.getValue();
        }
        if ((rootPar = (StringParameter)this.getParameter("root")) != null) {
            this.rootName = rootPar.getValue();
        }
        try {
            StringParameter angpar;
            StringParameter collpar;
            StringParameter rpar;
            StringParameter npar;
            StringParameter mpar;
            StringParameter lpar;
            StringParameter apar = (StringParameter)this.getParameter("a");
            if (apar != null) {
                this.helixAlgorithm = Integer.parseInt(apar.getValue());
                if (!BridgeItController.validateHelixAlgorithm(this.helixAlgorithm)) {
                    throw new CommandExecutionException("Unknown helix algorithm id: " + this.helixAlgorithm);
                }
            }
            if ((lpar = (StringParameter)this.getParameter("l")) != null) {
                this.lenMax = Integer.parseInt(lpar.getValue());
            }
            if ((mpar = (StringParameter)this.getParameter("m")) != null) {
                this.lenMin = Integer.parseInt(mpar.getValue());
            }
            if ((npar = (StringParameter)this.getParameter("n")) != null) {
                this.solutionId = Integer.parseInt(npar.getValue());
            }
            if ((rpar = (StringParameter)this.getParameter("rms")) != null) {
                this.rms = Double.parseDouble(rpar.getValue());
            }
            if ((collpar = (StringParameter)this.getParameter("coll")) != null) {
                this.collisionDistance = Double.parseDouble(collpar.getValue());
            }
            if ((angpar = (StringParameter)this.getParameter("angle")) != null) {
                this.angleWeight = Double.parseDouble(angpar.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Could not parse number: " + nfe.getMessage());
        }
    }
}

