/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class MoveCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "move";
    private Object3DGraphController controller;
    private String origName;
    private String newParentName;

    public MoveCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        MoveCommand command = new MoveCommand(this.controller);
        command.origName = this.origName;
        command.newParentName = this.newParentName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: move originalname newparentname";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"move\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " ORIGINALNAME NEWPARENTNAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Move command moves an object within a tree." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            this.controller.getGraph().moveObject(this.origName, this.newParentName);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 2) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.origName = p0.getValue();
        StringParameter p1 = (StringParameter)this.getParameter(1);
        this.newParentName = p1.getValue();
    }
}

