/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.ParsingException;
import java.util.HashSet;
import java.util.Set;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Mutation;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import sequence.DnaTools;
import sequence.UnknownSymbolException;

public class MutateCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "mutate";
    private Object3DGraphController controller;
    private String[] mutationDescriptors;
    private double rmsLimit = 3.0;
    private boolean forceMode = false;

    public MutateCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        MutateCommand command = new MutateCommand(this.controller);
        command.controller = this.controller;
        command.mutationDescriptors = this.mutationDescriptors;
        command.rmsLimit = this.rmsLimit;
        command.forceMode = this.forceMode;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String synopsis() {
        return "mutate [force=false|true][rms=VALUE] chainname:<symbol><pos>[,<symbol><pos> ...] . Example: mutate A:C5,G15,A2 B:U1,G2,A15 D:CGAUCAAUGUA\n";
    }

    private String helpOutput() {
        return "Mutates bases or base pairs. Correct usage: " + this.synopsis();
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"mutate\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.synopsis() + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Mutates base pairs and nucleotides in single or double strands." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        return helpText;
    }

    private static boolean isSinglePositionString(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isDigit(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public Set<Mutation> parseMutationDescriptors(String[] mutationDescriptors) throws CommandExecutionException {
        HashSet<Mutation> mutations = new HashSet<Mutation>();
        for (int i = 0; i < mutationDescriptors.length; ++i) {
            if (mutationDescriptors[i].indexOf("=") >= 0) continue;
            String[] words = mutationDescriptors[i].split(":");
            if (words.length != 2) {
                throw new CommandExecutionException("Syntax for mutation descriptor: chainname:<symbol><pos>[,<symbol><pos> ...] . Example: mutate A:C5,G15,A2 B:U1,G2,A15 \n");
            }
            String chainName = words[0];
            String posDesc = words[1];
            if (MutateCommand.isSinglePositionString(posDesc)) {
                String[] muts = posDesc.split(",");
                for (int j = 0; j < muts.length; ++j) {
                    char symbolChar = muts[j].toUpperCase().charAt(0);
                    String numberString = muts[j].substring(1);
                    try {
                        int pos = Integer.parseInt(numberString) - 1;
                        mutations.add(new Mutation(chainName, pos, symbolChar));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new CommandExecutionException("Could not interpret position number: " + numberString + " . Syntax for mutation descriptor: chainname:<symbol><pos>[,<symbol><pos> ...] . Example: mutate A:C5,G15,A2 B:U1,G2,A15 \n");
                    }
                    catch (UnknownSymbolException use) {
                        throw new CommandExecutionException("Unknown sequence symbol in " + posDesc + " Currently allowed symbols are: " + DnaTools.RNA_ALPHABET);
                    }
                }
                continue;
            }
            posDesc = posDesc.toUpperCase();
            int j = 0;
            while (j < posDesc.length()) {
                char symbolChar = posDesc.charAt(j);
                try {
                    int pos = j++;
                    mutations.add(new Mutation(chainName, pos, symbolChar));
                }
                catch (UnknownSymbolException use) {
                    throw new CommandExecutionException("Unknown sequence symbol in " + posDesc + " Currently allowed symbols are: " + DnaTools.RNA_ALPHABET);
                }
            }
        }
        return mutations;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        Set<Mutation> mutations = this.parseMutationDescriptors(this.mutationDescriptors);
        System.out.println("Applying the following mutations:");
        for (Mutation mutation : mutations) {
            System.out.print("" + mutation + "; ");
        }
        System.out.println();
        try {
            this.controller.mutateSequences(mutations, this.rmsLimit, this.forceMode);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        int numPar = this.getParameterCount();
        this.mutationDescriptors = new String[numPar];
        for (int i = 0; i < numPar; ++i) {
            StringParameter parameter = (StringParameter)this.getParameter(i);
            this.mutationDescriptors[i] = parameter.toString();
        }
        try {
            StringParameter parameter = (StringParameter)this.getParameter("force");
            if (parameter != null) {
                this.forceMode = parameter.parseBoolean();
            }
            if ((parameter = (StringParameter)this.getParameter("rms")) != null) {
                this.rmsLimit = Double.parseDouble(parameter.getValue());
            }
        }
        catch (ParsingException pe) {
            throw new CommandExecutionException(pe.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException(nfe.getMessage());
        }
    }
}

