/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import controltools.ModelChangeEvent;
import generaltools.ParsingException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnamodel.FitParameters;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.SimpleObject3DSet;

public class OptimizeBasepairsCommand
extends AbstractCommand {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final String COMMAND_NAME = "optconstraints";
    private boolean addHelicesFlag = true;
    private double electrostaticWeight = 0.0;
    private boolean keepFirstFixed = false;
    private double vdwWeight = 0.0;
    private String helixRootName = "root";
    private double kt = 2.0;
    private int numSteps = 1000000;
    private List<Object3DSet> objectBlocks;
    private int optimizerAlgorithm = 0;
    private boolean placeBestJunctions = true;
    private double rmsLimit = 3.0;
    private double stemRmsLimit = 10.0;
    private double stemAngleLimit = Math.PI;
    private double errorScoreLimit = 0.5;
    private Object3DGraphController controller;
    private String movableNames = null;
    private PrintStream ps;
    private List<Vector3D> fixedRotationAxisList;
    private int[] symVdwActive;

    public OptimizeBasepairsCommand(Object3DGraphController controller, PrintStream ps) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
        this.ps = ps;
    }

    @Override
    public Object cloneDeep() {
        OptimizeBasepairsCommand command = new OptimizeBasepairsCommand(this.controller, this.ps);
        command.addHelicesFlag = this.addHelicesFlag;
        command.electrostaticWeight = this.electrostaticWeight;
        command.fixedRotationAxisList = this.fixedRotationAxisList;
        command.helixRootName = this.helixRootName;
        command.keepFirstFixed = this.keepFirstFixed;
        command.kt = this.kt;
        command.movableNames = this.movableNames;
        command.numSteps = this.numSteps;
        command.objectBlocks = this.objectBlocks;
        command.placeBestJunctions = this.placeBestJunctions;
        command.optimizerAlgorithm = this.optimizerAlgorithm;
        command.rmsLimit = this.rmsLimit;
        command.stemAngleLimit = this.stemAngleLimit;
        command.stemRmsLimit = this.stemRmsLimit;
        command.errorScoreLimit = this.errorScoreLimit;
        command.vdwWeight = this.vdwWeight;
        command.symVdwActive = this.symVdwActive;
        return command;
    }

    private Object3DSet generateMovableObjects(String movableNames) throws CommandExecutionException {
        if (movableNames == null) {
            return null;
        }
        String[] words = movableNames.split(",");
        if (words == null || words.length == 0) {
            return null;
        }
        SimpleObject3DSet oset = new SimpleObject3DSet();
        for (int i = 0; i < words.length; ++i) {
            Object3D obj = this.controller.getGraph().findByFullName(words[i]);
            if (obj == null) {
                throw new CommandExecutionException("Could not find object: " + words[i]);
            }
            oset.add(obj);
        }
        return oset;
    }

    private int[] parseIntIds(String symIds) throws CommandExecutionException {
        int[] result = null;
        try {
            String[] words = symIds.split(",");
            result = new int[words.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Integer.parseInt(words[i]);
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing symmetry ids: " + nfe.getMessage());
        }
        return result;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        this.ps.println("Starting to optimize helices!");
        FitParameters stemFitParameters = null;
        Properties properties = new Properties();
        if (this.addHelicesFlag) {
            stemFitParameters = new FitParameters(this.stemRmsLimit, this.stemAngleLimit);
        }
        if (this.objectBlocks == null) {
            throw new CommandExecutionException("No object blocks defined!");
        }
        if (this.objectBlocks.size() == 0) {
            throw new CommandExecutionException("Zero object blocks defined!");
        }
        try {
            Object3DSet movableObjects = this.generateMovableObjects(this.movableNames);
            if (movableObjects != null) {
                this.ps.println("Number of movable objects: " + movableObjects.size());
            } else {
                this.ps.println("All objects with constraints are considered movable.");
            }
            this.ps.println("Number of optimization steps: " + this.numSteps);
            this.ps.println("Electrostatic repulsion term weight: " + this.electrostaticWeight);
            this.ps.println("Van de Waals repulsion term weight: " + this.vdwWeight);
            this.ps.println("Tolerance: " + this.kt);
            this.ps.println("Number of object blocks: " + this.objectBlocks.size());
            properties = this.controller.optimizeBasepairs(this.numSteps, this.errorScoreLimit, this.electrostaticWeight, this.vdwWeight, this.kt, this.objectBlocks, this.fixedRotationAxisList, this.symVdwActive, this.keepFirstFixed, this.placeBestJunctions, this.helixRootName);
        }
        catch (Object3DGraphControllerException gce) {
            throw new CommandExecutionException(gce.getMessage());
        }
        this.controller.refresh(new ModelChangeEvent((Object)this.controller, 4));
        this.ps.println("Helix optimization finished! Result:");
        this.ps.println(properties.toString());
        this.resultProperties = properties;
    }

    List<Object3DSet> parseObjectBlocks(String blocks) throws CommandExecutionException {
        if (blocks == null || blocks.length() == 0) {
            throw new CommandExecutionException("blocks option has to be defined! See usage.");
        }
        ArrayList<Object3DSet> result = new ArrayList<Object3DSet>();
        String[] setWords = blocks.split(";");
        for (int i = 0; i < setWords.length; ++i) {
            String[] objWords = setWords[i].split(",");
            if (objWords.length < 1) {
                throw new CommandExecutionException("Error in optbasepairs: expected at least one object in " + setWords[i]);
            }
            SimpleObject3DSet set = new SimpleObject3DSet();
            for (int j = 0; j < objWords.length; ++j) {
                String objName = objWords[j];
                Object3D obj = this.controller.getGraph().findByFullName(objName);
                if (obj == null) {
                    throw new CommandExecutionException("Could not find object with name: " + objName);
                }
                set.add(obj);
            }
            result.add(set);
        }
        return result;
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private Vector3D parseVector(String s) throws CommandExecutionException {
        if (s == null || s.equals("")) {
            return null;
        }
        String[] words = s.split(",");
        if (words.length != 3) {
            throw new CommandExecutionException("Expected 3 words in vector descriptor: " + s);
        }
        Vector3D result = new Vector3D();
        try {
            result.setX(Double.parseDouble(words[0]));
            result.setY(Double.parseDouble(words[1]));
            result.setZ(Double.parseDouble(words[2]));
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing item of vector descriptor: " + s);
        }
        if (result.length() == 0.0) {
            throw new CommandExecutionException("Zero vector length found in vector descriptor: " + s);
        }
        return result;
    }

    private List<Vector3D> parseAxisList(String s) throws CommandExecutionException {
        String[] words = s.split(";");
        ArrayList<Vector3D> result = new ArrayList<Vector3D>();
        for (int i = 0; i < words.length; ++i) {
            result.add(this.parseVector(words[i]));
        }
        return result;
    }

    private void prepareReadout() throws CommandExecutionException {
        Command importParameter = this.getParameter("helices");
        if (importParameter != null) {
            String value = ((StringParameter)importParameter).getValue().toLowerCase();
            if (value.equals("true")) {
                this.addHelicesFlag = true;
            } else if (value.equals("false")) {
                this.addHelicesFlag = false;
            } else {
                throw new CommandExecutionException(this.helpOutput());
            }
        }
        try {
            Command symParameter;
            Command vdwParameter;
            Command placeParameter;
            Command fixedParameter;
            Command movableParameter;
            Command helixRootParameter;
            Command errorLimitParameter;
            Command firstFixedParameter;
            Command ktParameter;
            Command repulsParameter;
            Command stepsParameter;
            Command rmsParameter = this.getParameter("rms");
            if (rmsParameter != null) {
                this.rmsLimit = Double.parseDouble(((StringParameter)rmsParameter).getValue());
            }
            if ((stepsParameter = this.getParameter("steps")) != null) {
                this.numSteps = Integer.parseInt(((StringParameter)stepsParameter).getValue());
            }
            if ((repulsParameter = this.getParameter("repuls")) != null) {
                this.electrostaticWeight = Double.parseDouble(((StringParameter)repulsParameter).getValue());
            }
            if ((ktParameter = this.getParameter("kt")) != null) {
                this.kt = Double.parseDouble(((StringParameter)ktParameter).getValue());
            }
            if ((firstFixedParameter = this.getParameter("firstfixed")) != null) {
                this.keepFirstFixed = ((StringParameter)firstFixedParameter).parseBoolean();
            }
            if ((errorLimitParameter = this.getParameter("error")) != null) {
                this.errorScoreLimit = Double.parseDouble(((StringParameter)errorLimitParameter).getValue());
            }
            if ((helixRootParameter = this.getParameter("helixroot")) != null) {
                this.helixRootName = ((StringParameter)helixRootParameter).getValue();
            }
            if ((movableParameter = this.getParameter("movable")) != null) {
                this.movableNames = ((StringParameter)movableParameter).getValue();
            }
            String movableParameterValue = "";
            if ((movableParameterValue = this.parse("blocks", movableParameterValue)) != null) {
                this.objectBlocks = this.parseObjectBlocks(movableParameterValue);
            }
            if ((fixedParameter = this.getParameter("fixed")) != null) {
                this.fixedRotationAxisList = this.parseAxisList(((StringParameter)fixedParameter).getValue());
                if (this.fixedRotationAxisList.size() != this.objectBlocks.size()) {
                    throw new CommandExecutionException("Number of rotation constraint vectors has to be equal to number of blocks.");
                }
            }
            if ((placeParameter = this.getParameter("place")) != null) {
                this.placeBestJunctions = ((StringParameter)placeParameter).parseBoolean();
            }
            if ((vdwParameter = this.getParameter("vdw")) != null) {
                this.vdwWeight = Double.parseDouble(((StringParameter)vdwParameter).getValue());
            }
            if ((symParameter = this.getParameter("symvdw")) != null) {
                this.symVdwActive = this.parseIntIds(((StringParameter)symParameter).getValue());
            }
        }
        catch (ParsingException pe) {
            throw new CommandExecutionException("Parsing exception: " + pe.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Bad number format detected: " + nfe.getMessage());
        }
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"optconstraints\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Optimize distance and/or basepair constraints." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     blocks=name1[,name2[...]][;name3[,name4[...]]]] : defines object blocks" + PackageConstants.NEWLINE;
        helpText = helpText + "     error=DOUBLE" + PackageConstants.NEWLINE + "          Set the error limit parameter." + PackageConstants.NEWLINE;
        helpText = helpText + "     firstfixed=false|true   : Keep first block unchanged. Default: false." + PackageConstants.NEWLINE;
        helpText = helpText + "     fixed=a,b,c[;d,e,f[;...]]   : constrain rotation axis of movable blocks." + PackageConstants.NEWLINE;
        helpText = helpText + "     kt=DOUBLE : value of kT for optimization. Default: 2.0" + PackageConstants.NEWLINE;
        helpText = helpText + "     movable=name1[,name2,[...]]" + PackageConstants.NEWLINE;
        helpText = helpText + "     repuls=DOUBLE : weight of residue repulsion term. Default: 0.0" + PackageConstants.NEWLINE;
        helpText = helpText + "     rms=DOUBLE" + PackageConstants.NEWLINE + "          TODO" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     steps=NUMBER : number of optimization steps." + PackageConstants.NEWLINE;
        helpText = helpText + "     symvdw=ID1,ID2,...  : ids of symmetry copies that are used for repulstion term computation." + PackageConstants.NEWLINE;
        helpText = helpText + "     vdw=DOUBLE   : weight of residue repulsion term. Default: 0.0" + PackageConstants.NEWLINE;
        return helpText;
    }

    private String helpOutput() {
        return "Correct usage: optconstraints [blocks=name1[,name2[...]][;name3[,name4[...]]]] [error=value][firstfixed=false|true][kt=value][fixed=a,b,c[;d,e,f[...]]][place=true|false][repuls=<value>][rms=<value>] [steps=<value>][symvdw=ID1,ID2,...][vdw=WEIGHT]";
    }
}

