/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import controltools.ModelChangeEvent;
import java.io.PrintStream;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnamodel.RnaConstants;

public class OptimizeRnaGraphCommand
extends AbstractCommand {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final String COMMAND_NAME = "optrnagraph";
    private String rootName = "root";
    private double offset = RnaConstants.JUNCTION_OFFSET;
    private int numSteps = 100000;
    private double errorScoreLimit = 3.0;
    private Object3DGraphController controller;
    private PrintStream ps;
    private int verboseLevel = 1;

    public OptimizeRnaGraphCommand(Object3DGraphController controller, PrintStream ps) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
        this.ps = ps;
    }

    @Override
    public Object cloneDeep() {
        OptimizeRnaGraphCommand command = new OptimizeRnaGraphCommand(this.controller, this.ps);
        command.rootName = this.rootName;
        command.offset = this.offset;
        command.numSteps = this.numSteps;
        command.errorScoreLimit = this.errorScoreLimit;
        command.verboseLevel = this.verboseLevel;
        return command;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        if (this.verboseLevel > 1) {
            this.ps.println("Starting to optimize graph edges with parameters:" + this.rootName + " " + this.numSteps + " " + this.errorScoreLimit + " " + this.verboseLevel);
        }
        Object stemFitParameters = null;
        Properties properties = new Properties();
        try {
            properties = this.controller.optimizeRnaIntegerGraph(this.rootName, this.numSteps, this.errorScoreLimit, this.offset, this.verboseLevel);
        }
        catch (Object3DGraphControllerException gce) {
            throw new CommandExecutionException(gce.getMessage());
        }
        this.controller.refresh(new ModelChangeEvent((Object)this.controller, 4));
        this.ps.println("Helix optimization finished! Result:");
        this.ps.println(properties.toString());
        this.resultProperties = properties;
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 1) {
            this.helpOutput();
            throw new CommandExecutionException("Missing parameter: root");
        }
        try {
            Command rootParameter;
            Command offsetParameter;
            Command errorLimitParameter;
            Command verboseParameter;
            Command stepsParameter = this.getParameter("steps");
            if (stepsParameter != null) {
                this.numSteps = Integer.parseInt(((StringParameter)stepsParameter).getValue());
            }
            if ((verboseParameter = this.getParameter("verbose")) != null) {
                this.verboseLevel = Integer.parseInt(((StringParameter)verboseParameter).getValue());
            }
            if ((errorLimitParameter = this.getParameter("error")) != null) {
                this.errorScoreLimit = Double.parseDouble(((StringParameter)errorLimitParameter).getValue());
            }
            if ((offsetParameter = this.getParameter("offset")) != null) {
                this.offset = Double.parseDouble(((StringParameter)offsetParameter).getValue());
            }
            if ((rootParameter = this.getParameter("root")) != null) {
                this.rootName = ((StringParameter)rootParameter).getValue();
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Bad number format detected: " + nfe.getMessage());
        }
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"optrnagraph\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Optimize graph edge lengths." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     error=DOUBLE" + PackageConstants.NEWLINE + "          Set the error limit parameter." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     root=name  : use graph at subtree with this name" + PackageConstants.NEWLINE;
        helpText = helpText + "     offset=value  : Length of uncovered helices." + PackageConstants.NEWLINE;
        return helpText;
    }

    private String helpOutput() {
        return "Correct usage: optrnagraph root=NAME [error=value] [steps=<value>] [offset=<value>]";
    }
}

