/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.Vector3D;

public class PlaceCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "place";
    private Object3DGraphController controller;
    private String newParentName;
    private String newName;
    private String ending;
    private char subCommandChar;
    private Vector3D newPos;
    private int order;
    private int id;

    public PlaceCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        PlaceCommand command = new PlaceCommand(this.controller);
        command.newParentName = this.newParentName;
        command.newName = this.newName;
        command.newPos = this.newPos;
        command.order = this.order;
        command.id = this.id;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: place j|k parentname name order index x y z strandending";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"place\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " j|k newparentname newname order id x y z strand-ending" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     places specified junction at certain position in space." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            switch (this.subCommandChar) {
                case 'j': {
                    this.controller.placeJunction(this.order, this.id, this.newParentName, this.newName, this.newPos, this.ending);
                    break;
                }
                case 'k': {
                    this.controller.placeKissingLoop(this.order, this.id, this.newParentName, this.newName, this.newPos, this.ending);
                    break;
                }
                default: {
                    throw new CommandExecutionException("Unknown subcommand: " + this.subCommandChar);
                }
            }
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 9) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        if (!p0.getValue().equals("j") && !p0.getValue().equals("k")) {
            throw new CommandExecutionException("Expected j or k keyword");
        }
        this.subCommandChar = p0.getValue().charAt(0);
        StringParameter p1 = (StringParameter)this.getParameter(1);
        this.newParentName = p1.getValue();
        StringParameter p2 = (StringParameter)this.getParameter(2);
        this.newName = p2.getValue();
        StringParameter p3 = (StringParameter)this.getParameter(3);
        this.order = Integer.parseInt(p3.getValue());
        StringParameter p4 = (StringParameter)this.getParameter(4);
        this.id = Integer.parseInt(p4.getValue());
        --this.id;
        StringParameter p5 = (StringParameter)this.getParameter(5);
        double x = Double.parseDouble(p5.getValue());
        StringParameter p6 = (StringParameter)this.getParameter(6);
        double y = Double.parseDouble(p6.getValue());
        StringParameter p7 = (StringParameter)this.getParameter(7);
        double z = Double.parseDouble(p7.getValue());
        this.newPos = new Vector3D(x, y, z);
        StringParameter endingParameter = (StringParameter)this.getParameter(8);
        if (endingParameter != null) {
            this.ending = endingParameter.getValue();
        }
    }
}

