/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class RingFuseCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "ringfuse";
    private Object3DGraphController controller;
    private String[] junctionNames;
    private String root = "root";
    private String name = "fused";

    public RingFuseCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        RingFuseCommand command = new RingFuseCommand(this.controller);
        command.junctionNames = this.junctionNames;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Fuses strands corresponding to a ring with as high symmetry as possible. Correct usage: ringfuse [junctions=subtree1,subtree2,...][root=SUBTREENAME][name=RESULTNAME]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"ringfuse\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput();
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            this.controller.ringFuseStrands(this.junctionNames, this.root, this.name);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException("Error while performing automated ring fusing: " + e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter p = (StringParameter)this.getParameter("junctions");
        if (p != null) {
            this.junctionNames = p.getValue().split(",");
        }
        if ((p = (StringParameter)this.getParameter("name")) != null) {
            this.name = p.getValue();
        }
        if ((p = (StringParameter)this.getParameter("root")) != null) {
            this.root = p.getValue();
        }
    }
}

