/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.Randomizer;
import rnadesign.designapp.PackageConstants;

public class SeedCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "seed";
    private long seed;

    public SeedCommand() {
        super(COMMAND_NAME);
    }

    @Override
    public Object cloneDeep() {
        SeedCommand command = new SeedCommand();
        command.seed = this.seed;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Resets random number generator with specified seed value. Correct usage: seed SEEDVALUE";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"seed\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Seed command resets random number generator with specified seed value." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "Example: seed 11" + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        Randomizer.setSeed(this.seed);
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 1) {
            StringParameter p0 = (StringParameter)this.getParameter(0);
            try {
                this.seed = Long.parseLong(p0.getValue());
            }
            catch (NumberFormatException e) {
                throw new CommandExecutionException("Bad number format: " + e.getMessage());
            }
        } else {
            throw new CommandExecutionException(this.helpOutput());
        }
    }
}

