/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class SplitStrandCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "splitstrand";
    private Object3DGraphController controller;
    private String name;
    private int position = -1;

    public SplitStrandCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        SplitStrandCommand command = new SplitStrandCommand(this.controller);
        command.name = this.name;
        command.position = this.position;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: splitstrand strandfullname position";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"splitstrand\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " strandfullname position" + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     splitstrand command splits a strand before specified position." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        if (this.position < 0) {
            throw new CommandExecutionException("No position specified. Usage: splitstrand strandfullname position");
        }
        try {
            this.controller.getGraph().splitStrand(this.name, this.position);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 2) {
            throw new CommandExecutionException(this.helpOutput());
        }
        try {
            StringParameter p0 = (StringParameter)this.getParameter(0);
            this.name = p0.getValue();
            StringParameter p1 = (StringParameter)this.getParameter(1);
            this.position = Integer.parseInt(p1.getValue()) - 1;
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing position in splitstrand: " + nfe.getMessage());
        }
    }
}

