/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.CoordinateSystem;
import tools3d.objects3d.Object3D;

public class SymAddCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "symadd";
    private Object3DGraphController controller;
    private String origName;

    public SymAddCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        SymAddCommand command = new SymAddCommand(this.controller);
        command.origName = this.origName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: symadd COORDINATESYSTEMNAME";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"symadd\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " OBJECTNAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     symadd adds a coordinate to the symmetry controller." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        Object3D obj = this.controller.getGraph().findByFullName(this.origName);
        if (obj == null) {
            throw new CommandExecutionException("Could not find object: " + this.origName);
        }
        if (!(obj instanceof CoordinateSystem)) {
            throw new CommandExecutionException("Object is not a coordinate system: " + this.origName);
        }
        this.controller.getSymmetryController().add((CoordinateSystem)((Object)obj));
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() > 0) {
            StringParameter p0 = (StringParameter)this.getParameter(0);
            this.origName = p0.getValue();
        }
    }
}

