/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class SymApplyCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "symapply";
    private Object3DGraphController controller;
    private String origName;
    private int symId = 0;

    public SymApplyCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        SymApplyCommand command = new SymApplyCommand(this.controller);
        command.origName = this.origName;
        command.symId = this.symId;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: symapply rootname + symmetryid";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"symapply\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " OBJECTNAME SYMMETRYID" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     symapply applies symmetry transformation to subtree" + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            this.controller.getGraph().applySymmetry(this.origName, this.symId);
        }
        catch (Object3DGraphControllerException oce) {
            throw new CommandExecutionException(oce.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 2) {
            throw new CommandExecutionException("Two parameters expected in symapply : " + this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.origName = p0.getValue();
        StringParameter p1 = (StringParameter)this.getParameter(1);
        try {
            this.symId = Integer.parseInt(p1.getValue());
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing symmetry id in symapply command: " + nfe.getMessage());
        }
    }
}

