/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;

public class TileCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "tile";
    private int xmin = 0;
    private int ymin = 0;
    private int zmin = 0;
    private int xmax = 0;
    private int ymax = 0;
    private int zmax = 0;
    private String name = "";
    private Object3DGraphController controller;

    public TileCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        TileCommand command = new TileCommand(this.controller);
        command.xmin = this.xmin;
        command.ymin = this.ymin;
        command.zmin = this.zmin;
        command.xmax = this.xmax;
        command.ymax = this.ymax;
        command.zmax = this.zmax;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Correct usage: tile xmin ymin zmin xmax ymax zmax";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"tile\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " xMin yMin zMin xMax yMax zMax name" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Tile command TODO.";
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        this.controller.tileSpace(this.xmin, this.ymin, this.zmin, this.xmax, this.ymax, this.zmax, this.name);
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 7) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        StringParameter p1 = (StringParameter)this.getParameter(1);
        StringParameter p2 = (StringParameter)this.getParameter(2);
        StringParameter p3 = (StringParameter)this.getParameter(3);
        StringParameter p4 = (StringParameter)this.getParameter(4);
        StringParameter p5 = (StringParameter)this.getParameter(5);
        StringParameter p6 = (StringParameter)this.getParameter(6);
        this.xmin = Integer.parseInt(p0.getValue());
        this.ymin = Integer.parseInt(p1.getValue());
        this.zmin = Integer.parseInt(p2.getValue());
        this.xmax = Integer.parseInt(p3.getValue());
        this.ymax = Integer.parseInt(p4.getValue());
        this.zmax = Integer.parseInt(p5.getValue());
        this.name = p6.getValue();
    }
}

