/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import rnadesign.designapp.rnagui.AbstractPainter;
import rnadesign.designapp.rnagui.GeometryPainter;
import rnadesign.designapp.rnagui.RnaStrandColorModel;
import tools3d.Appearance;
import tools3d.Character3D;
import tools3d.Drawable;
import tools3d.Edge3D;
import tools3d.Face3D;
import tools3d.Geometry;
import tools3d.GeometryColorModel;
import tools3d.Point3D;
import tools3d.Positionable3D;
import tools3d.Vector3D;
import tools3d.ZBuffer;

public abstract class AbstractGeometryPainter
extends AbstractPainter
implements GeometryPainter {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    ZBuffer zBuf = new ZBuffer();
    Set<String> forbiddenClassNames = new HashSet<String>();
    private boolean paintLinks = true;
    private boolean depthCueing = true;
    protected GeometryColorModel geometryColorModel = new RnaStrandColorModel();
    protected boolean paintCharacterMode = false;

    public boolean getDepthCueing() {
        return this.depthCueing;
    }

    public void setDepthCueing(boolean depthCueing) {
        this.depthCueing = depthCueing;
    }

    public boolean getPaintLinks() {
        return this.paintLinks;
    }

    public void setPaintLinks(boolean b) {
        this.paintLinks = b;
    }

    @Override
    public void addForbidden(String className) {
        this.forbiddenClassNames.add(className);
    }

    @Override
    public void clearForbidden() {
    }

    @Override
    public void removeForbidden(String className) {
        this.forbiddenClassNames.remove(className);
    }

    @Override
    public GeometryColorModel getGeometryColorModel() {
        return this.geometryColorModel;
    }

    @Override
    public Color getDefaultPaintColor(Drawable drawable) {
        Properties properties = drawable.getProperties();
        Appearance appearance = drawable.getAppearance();
        Vector3D normal = null;
        if (drawable instanceof Face3D) {
            normal = ((Face3D)drawable).getNormal();
        }
        return this.geometryColorModel.computeColor(this.getAmbiente(), appearance, properties, normal, this.getCameraController().getCamera());
    }

    @Override
    public boolean getPaintCharacterMode() {
        log.info("GOT HERE, LINE 43, ABSTRACTGEOMETRYPAINTER!");
        return this.paintCharacterMode;
    }

    @Override
    public boolean isPaintable(Drawable p) {
        Properties prop = p.getProperties();
        if (prop != null) {
            String className = prop.getProperty("class_name");
            return !this.forbiddenClassNames.contains(className);
        }
        return true;
    }

    @Override
    public void paint(Graphics g, Geometry geometry) {
        int i;
        this.zBuf.reset();
        for (i = 0; i < geometry.getNumberPoints(); ++i) {
            this.zBuf.add(geometry.getPoint(i));
        }
        for (i = 0; i < geometry.getNumberEdges(); ++i) {
            this.zBuf.add(geometry.getEdge(i));
        }
        for (i = 0; i < geometry.getNumberFaces(); ++i) {
            this.zBuf.add(geometry.getFace(i));
        }
        this.zBuf.sort();
        for (i = this.zBuf.size() - 1; i >= 0; --i) {
            Positionable3D p = this.zBuf.get(i);
            if (p instanceof Character3D && this.paintCharacterMode) {
                this.paintCharacter(g, (Character3D)p);
                continue;
            }
            if (p instanceof Point3D) {
                this.paintPoint(g, (Point3D)p);
                continue;
            }
            if (p instanceof Edge3D) {
                this.paintEdge(g, (Edge3D)p);
                continue;
            }
            if (!(p instanceof Face3D)) continue;
            this.paintFace(g, (Face3D)p);
        }
    }

    @Override
    public void paint(Graphics g, Drawable p) {
        if (p instanceof Character3D) {
            this.paintCharacter(g, (Character3D)p);
        } else if (p instanceof Point3D) {
            this.paintPoint(g, (Point3D)p);
        } else if (p instanceof Edge3D) {
            this.paintEdge(g, (Edge3D)p);
        } else if (p instanceof Face3D) {
            this.paintFace(g, (Face3D)p);
        }
    }

    @Override
    public void setGeometryColorModel(GeometryColorModel m) {
        this.geometryColorModel = m;
    }

    @Override
    public void setPaintCharacterMode(boolean b) {
        this.paintCharacterMode = b;
    }
}

