/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.rnagui.Wizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.objects3d.Object3D;

public class AddBasepairsWizard
implements Wizard {
    private static final int COL_SIZE_NAME = 20;
    private static final String FRAME_TITLE = "Generate Basepair Constraints Wizard";
    private boolean finished = false;
    private JFrame frame = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private CommandApplication application;
    private Vector<String> tree;
    private Set<String> allowedNames;
    private Set<String> forbiddenNames;
    private JPanel treePanel;
    private JButton treeButton;
    private JList treeList;
    private JScrollPane treeScroll;
    private JTextField selectionField1;
    private JTextField selectionField2;
    private JTextField lengthField;
    private JLabel label;

    public AddBasepairsWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
        this.allowedNames = new HashSet<String>();
        this.allowedNames.add("Nucleotide3D");
        this.forbiddenNames = new HashSet<String>();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addComponents() {
        Container f = this.frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        JPanel westCenterPanel = new JPanel();
        westCenterPanel.setLayout(new BorderLayout());
        this.label = new JLabel("Nucleotide 1: ");
        westCenterPanel.add((Component)this.label, "North");
        this.selectionField1 = new JTextField(this.getSelectionText(), 20);
        westCenterPanel.add((Component)this.selectionField1, "Center");
        westCenterPanel.add((Component)new TreePanel(this.selectionField1), "South");
        centerPanel.add((Component)westCenterPanel, "West");
        JPanel centerCenterPanel = new JPanel();
        centerCenterPanel.setLayout(new BorderLayout());
        this.label = new JLabel("Nucleotide 2: ");
        centerCenterPanel.add((Component)this.label, "North");
        this.selectionField2 = new JTextField(this.getSelectionText(), 20);
        centerCenterPanel.add((Component)this.selectionField2, "Center");
        centerCenterPanel.add((Component)new TreePanel(this.selectionField2), "South");
        centerPanel.add((Component)centerCenterPanel, "East");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.label = new JLabel("Length:");
        buttonPanel.add(this.label);
        this.lengthField = new JTextField(3);
        buttonPanel.add(this.lengthField);
        JButton button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        buttonPanel.add(button);
        button = new JButton("Add Basepair");
        button.addActionListener(new AddBasepairListener());
        buttonPanel.add(button);
        f.add((Component)centerPanel, "Center");
        f.add((Component)buttonPanel, "South");
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Component parentFrame) {
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents();
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    private String getSelectionText() {
        Object3DGraphController graphController = ((AbstractDesigner)this.application).getGraphController();
        Object3DController gControl = graphController.getGraph();
        Object3D selection = gControl.getSelectionRoot();
        if (selection == null) {
            return "";
        }
        String selectionName = selection.getName();
        Object3D curr = selection;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            selectionName = curr.getName() + "." + selectionName;
        }
        return selectionName;
    }

    private class TreePanel
    extends JPanel {
        public TreePanel(JTextField field) {
            Object3DGraphController controller = ((AbstractDesigner)AddBasepairsWizard.this.application).getGraphController();
            AddBasepairsWizard.this.tree = controller.getGraph().getTree(AddBasepairsWizard.this.allowedNames, AddBasepairsWizard.this.forbiddenNames);
            this.setLayout(new BorderLayout());
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 1));
            labelPanel.add(new JLabel("Tree:"));
            this.add(labelPanel);
            AddBasepairsWizard.this.treePanel = new JPanel();
            AddBasepairsWizard.this.treeList = new JList(AddBasepairsWizard.this.tree);
            AddBasepairsWizard.this.treeList.addListSelectionListener(new SelectionListener(field));
            AddBasepairsWizard.this.treeScroll = new JScrollPane(AddBasepairsWizard.this.treeList);
            AddBasepairsWizard.this.treeScroll.setVerticalScrollBarPolicy(20);
            AddBasepairsWizard.this.treeScroll.setHorizontalScrollBarPolicy(30);
            AddBasepairsWizard.this.treeScroll.setPreferredSize(new Dimension(300, 200));
            AddBasepairsWizard.this.treePanel.add(AddBasepairsWizard.this.treeScroll);
            this.add((Component)AddBasepairsWizard.this.treePanel, "South");
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTextField field;

        public SelectionListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                String text = (String)AddBasepairsWizard.this.tree.get(e.getFirstIndex());
                if ((text = text.substring(0, text.indexOf(" "))).equals(this.field.getText())) {
                    text = (String)AddBasepairsWizard.this.tree.get(e.getLastIndex());
                    text = text.substring(0, text.indexOf(" "));
                }
                this.field.setText(text);
            }
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddBasepairsWizard.this.frame.setVisible(false);
            AddBasepairsWizard.this.frame = null;
            AddBasepairsWizard.this.finished = true;
        }
    }

    private class AddBasepairListener
    implements ActionListener {
        private AddBasepairListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = "genbpconstraint " + AddBasepairsWizard.this.selectionField1.getText().trim() + " " + AddBasepairsWizard.this.selectionField2.getText().trim() + " " + AddBasepairsWizard.this.lengthField.getText().trim();
            try {
                AddBasepairsWizard.this.application.runScriptLine(command);
                AddBasepairsWizard.this.frame.setVisible(false);
                AddBasepairsWizard.this.frame = null;
                AddBasepairsWizard.this.finished = true;
            }
            catch (CommandException ce) {
                JOptionPane.showMessageDialog(AddBasepairsWizard.this.frame, ce + ": " + ce.getMessage());
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddBasepairsWizard.this.frame.setVisible(false);
            AddBasepairsWizard.this.frame = null;
            AddBasepairsWizard.this.finished = true;
        }
    }
}

