/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.rnagui.Wizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.objects3d.Object3D;

public class ChosenWizard
implements Wizard {
    private static final int COL_SIZE_NAME = 20;
    private static final String FRAME_TITLE = "Chosen Wizard";
    private boolean finished = false;
    private JFrame frame = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private CommandApplication application;

    public ChosenWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addComponents() {
        Container f = this.frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.add(new JLabel(this.getSelectionText()));
        f.add((Component)panel, "North");
        JPanel buttonPanel = new JPanel();
        JButton button = new JButton("Done");
        button.addActionListener(new DoneListener());
        buttonPanel.add(button);
        f.add((Component)buttonPanel, "South");
    }

    private String getSelectionText() {
        try {
            this.application.runScriptLine("chosen");
        }
        catch (CommandException e) {
            JOptionPane.showMessageDialog(this.frame, e + ": " + e.getMessage());
        }
        Object3DGraphController graphController = ((AbstractDesigner)this.application).getGraphController();
        Object3DController gControl = graphController.getGraph();
        Object3D selection = gControl.getSelectionRoot();
        if (selection == null) {
            return "undefined";
        }
        String selectionName = selection.getName();
        Object3D curr = selection;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            selectionName = curr.getName() + "." + selectionName;
        }
        return selectionName;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Component parentFrame) {
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents();
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChosenWizard.this.frame.setVisible(false);
            ChosenWizard.this.frame = null;
            ChosenWizard.this.finished = true;
        }
    }
}

