/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import rnadesign.designapp.rnagui.GeometryPainter;
import rnadesign.designapp.rnagui.Object3DPainter;
import rnadesign.designapp.rnagui.Object3DSinglePainter;
import rnadesign.designapp.rnagui.Object3DSinglePainterChooser;
import rnadesign.designapp.rnagui.RnaGuiParameters;
import rnadesign.designapp.rnagui.Shape3DPainter;
import rnadesign.designapp.rnagui.SimpleOriginFactory;
import rnadesign.designapp.rnagui.SimpleSinglePainterChooser;
import rnadesign.designapp.rnagui.WireGeometryPainter;
import rnadesign.rnacontrol.CameraController;
import rnadesign.rnacontrol.Kaleidoscope;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.SimpleCameraController;
import tools3d.AbstractGeometryElement;
import tools3d.Drawable;
import tools3d.Geometry;
import tools3d.Positionable3D;
import tools3d.Shape3D;
import tools3d.Shape3DSet;
import tools3d.ZBuffer;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Primitive3D;

public class GeneralPainter
implements Object3DPainter {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    int[] xTmpArray;
    int[] yTmpArray;
    double geometryAngleDelta = 0.17453292519943295;
    boolean originMode = true;
    Primitive3D[] originPrimitives;
    Object3DSinglePainterChooser painterChooser = new SimpleSinglePainterChooser();
    Shape3DPainter shapePainter = null;
    GeometryPainter geometryPainter = new WireGeometryPainter();
    CameraController cameraController = new SimpleCameraController();
    Kaleidoscope kaleidoscope;
    private RnaGuiParameters params;
    private ZBuffer zBuf = new ZBuffer();

    GeneralPainter(RnaGuiParameters p, Shape3DPainter shapePainter, Kaleidoscope kaleidoscope) {
        this.params = p;
        SimpleOriginFactory originFactory = new SimpleOriginFactory();
        this.originPrimitives = originFactory.createOrigin();
        this.shapePainter = shapePainter;
        this.kaleidoscope = kaleidoscope;
    }

    @Override
    public void copy(Object3DPainter other) {
        if (other instanceof GeneralPainter) {
            GeneralPainter c = (GeneralPainter)other;
            this.cameraController.copy(c.cameraController);
            this.params.copy(c.params);
        }
    }

    public void drawObject3D(Graphics2D g2, Object3D obj3d) {
        Object3DSinglePainter singlePainter = this.painterChooser.choosePainter(obj3d);
        if (singlePainter != null) {
            singlePainter.setCameraController(this.cameraController);
            singlePainter.paint(g2, obj3d);
        } else {
            Point2D point = this.cameraController.project(obj3d.getPosition());
            double posX = point.getX();
            double posY = point.getY();
            g2.fill(new Rectangle2D.Double(posX, posY, this.params.rectWidth, this.params.rectHeight));
        }
    }

    public void drawPrimitive(Graphics2D g2, Primitive3D p3d) {
        if (p3d == null) {
            log.severe("Called drawPrimitive with null object!");
            return;
        }
        if (p3d.size() <= 0) {
            // empty if block
        }
        g2.setXORMode(p3d.getColor());
        if (p3d.size() == 1) {
            Point2D point = this.cameraController.project(p3d.getPoint(0));
            double posX = point.getX();
            double posY = point.getY();
            g2.fill(new Ellipse2D.Double(posX, posY, this.params.circleRad, this.params.circleRad));
        } else if (p3d.size() == 2) {
            Point2D pointA = this.cameraController.project(p3d.getPoint(0));
            Point2D pointB = this.cameraController.project(p3d.getPoint(1));
            g2.draw(new Line2D.Double(pointA, pointB));
        } else {
            if (this.xTmpArray == null || this.xTmpArray.length != p3d.size()) {
                this.xTmpArray = new int[p3d.size()];
                this.yTmpArray = new int[p3d.size()];
            }
            for (int i = 0; i < p3d.size(); ++i) {
                Point2D point = this.cameraController.project(p3d.getPoint(i));
                this.xTmpArray[i] = (int)point.getX();
                this.xTmpArray[i] = (int)point.getY();
            }
            g2.fill(new Polygon(this.xTmpArray, this.yTmpArray, this.xTmpArray.length));
        }
    }

    @Override
    public CameraController getCameraController() {
        return this.cameraController;
    }

    @Override
    public void paint(Graphics g, Object3DGraphController graphController) {
        int i;
        Graphics2D g2 = (Graphics2D)g;
        boolean counter = false;
        this.zBuf.reset();
        this.zBuf.setDirection(this.cameraController.getViewDirection());
        Shape3DSet shapeSet = graphController.getShapeSet();
        if (shapeSet != null) {
            for (i = 0; i < shapeSet.size(); ++i) {
                AbstractGeometryElement posi;
                int j;
                Shape3D shape = shapeSet.get(i);
                Geometry geometry = shape.createGeometry(this.geometryAngleDelta);
                if (geometry == null) continue;
                for (j = 0; j < geometry.getNumberPoints(); ++j) {
                    posi = geometry.getPoint(j);
                    if (!this.geometryPainter.isPaintable(posi)) continue;
                    this.zBuf.add(posi);
                }
                for (j = 0; j < geometry.getNumberEdges(); ++j) {
                    posi = geometry.getEdge(j);
                    if (!this.geometryPainter.isPaintable(posi)) continue;
                    this.zBuf.add(posi);
                }
                for (j = 0; j < geometry.getNumberFaces(); ++j) {
                    posi = geometry.getFace(j);
                    if (!this.geometryPainter.isPaintable(posi)) continue;
                    this.zBuf.add(posi);
                }
            }
        } else {
            log.warning("shape set was null in GeneralPainter!");
        }
        if (this.originMode) {
            for (i = 0; i < this.originPrimitives.length; ++i) {
                this.zBuf.add(this.originPrimitives[i]);
            }
        }
        if (this.kaleidoscope != null && this.kaleidoscope.getSymmetryCount() > 1) {
            int origSize = this.zBuf.size();
            this.kaleidoscope.apply(this.zBuf);
            log.info("Generated kaleodoscope symmetries: " + this.zBuf.size());
        }
        this.zBuf.sort();
        for (i = this.zBuf.size() - 1; i >= 0; --i) {
            Positionable3D pobj = this.zBuf.get(i);
            if (pobj instanceof Object3D) {
                this.drawObject3D(g2, (Object3D)pobj);
                continue;
            }
            if (pobj instanceof Primitive3D) {
                this.drawPrimitive(g2, (Primitive3D)pobj);
                continue;
            }
            if (pobj instanceof Shape3D) {
                this.shapePainter.paint(g2, (Shape3D)pobj);
                continue;
            }
            if (!(pobj instanceof Drawable)) continue;
            this.geometryPainter.paint((Graphics)g2, (Drawable)pobj);
        }
    }

    public Object3DSinglePainterChooser getPainterChooser() {
        return this.painterChooser;
    }

    public Shape3DPainter getShapePainter() {
        return this.shapePainter;
    }

    @Override
    public void addForbidden(String className) {
        assert (false);
    }

    @Override
    public void clearForbidden() {
        assert (false);
    }

    @Override
    public void removeForbidden(String className) {
        assert (false);
    }

    @Override
    public void setCameraController(CameraController p) {
        this.cameraController = p;
    }

    public void setPainterChooser(Object3DSinglePainterChooser chooser) {
        this.painterChooser = chooser;
    }

    public void setShapePainter(Shape3DPainter painter) {
        this.shapePainter = painter;
    }
}

